/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.configuration.types;

import java.util.Map;
import java.util.function.Function;
import org.eclipse.serializer.configuration.types.Configuration;
import org.eclipse.serializer.configuration.types.ConfigurationMapper;
import org.eclipse.serializer.util.X;

public interface ConfigurationMapperMap
extends ConfigurationMapper<Map<String, ?>> {
    public static ConfigurationMapperMap New() {
        return new Default(Object::toString);
    }

    public static ConfigurationMapperMap New(Function<Object, String> toStringMapper) {
        return new Default((Function)X.notNull(toStringMapper));
    }

    public static class Default
    implements ConfigurationMapperMap {
        private final Function<Object, String> toStringMapper;

        Default(Function<Object, String> toStringMapper) {
            this.toStringMapper = toStringMapper;
        }

        @Override
        public Configuration.Builder mapConfiguration(Configuration.Builder builder, Map<String, ?> source) {
            this.mapConfiguration(builder, source, "");
            return builder;
        }

        private void mapConfiguration(Configuration.Builder builder, Map<String, ?> source, String prefix) {
            source.entrySet().forEach(e -> {
                String key = prefix.concat((String)e.getKey());
                Object value = e.getValue();
                if (value instanceof Map) {
                    this.mapConfiguration(builder, (Map)value, key + ".");
                } else if (value != null) {
                    builder.set(key, this.toStringMapper.apply(value));
                }
            });
        }
    }
}

