/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.configuration.types;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.serializer.configuration.types.DurationUnit;
import org.eclipse.serializer.util.X;

@FunctionalInterface
public interface DurationParser {
    public Duration parse(String var1);

    public static DurationParser New() {
        return new Default(DurationUnit.MS);
    }

    public static DurationParser New(DurationUnit defaultUnit) {
        return new Default((DurationUnit)((Object)X.notNull((Object)((Object)defaultUnit))));
    }

    public static class Default
    implements DurationParser {
        private static final Pattern ISO_PATTERN = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?", 2);
        private static final Pattern AMOUNT_UNIT_PATTERN = Pattern.compile("(?<amount>[0-9]*)(?:\\s*)(?<unit>[a-z]+)", 2);
        private final DurationUnit defaultUnit;

        Default(DurationUnit defaultUnit) {
            this.defaultUnit = defaultUnit;
        }

        @Override
        public Duration parse(String text) {
            if (ISO_PATTERN.matcher(text).matches()) {
                try {
                    return Duration.parse(text);
                }
                catch (DateTimeParseException e) {
                    throw new IllegalArgumentException("Invalid duration: " + text, e);
                }
            }
            Matcher matcher = AMOUNT_UNIT_PATTERN.matcher(text);
            if (matcher.matches()) {
                return this.parseDurationWithUnit(matcher.group("amount"), matcher.group("unit"));
            }
            try {
                return this.defaultUnit.create(Long.parseLong(text));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid duration: " + text, nfe);
            }
        }

        private Duration parseDurationWithUnit(String amountText, String unitText) {
            long amount;
            try {
                amount = Long.parseLong(amountText);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid duration: " + amountText + unitText, nfe);
            }
            try {
                return DurationUnit.valueOf(unitText.toUpperCase()).create(amount);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid duration: " + amountText + unitText + ", unknown unit: " + unitText);
            }
        }
    }
}

