/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.configuration.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.configuration.exceptions.ConfigurationExceptionNoConfigurationFound;
import org.eclipse.serializer.exceptions.IORuntimeException;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.logging.Logging;
import org.slf4j.Logger;

@FunctionalInterface
public interface ConfigurationLoader {
    public String loadConfiguration();

    public static ConfigurationLoader New(String path) {
        return ConfigurationLoader.New(path, Defaults.defaultCharset());
    }

    public static ConfigurationLoader New(String path, Charset charset) {
        URL url;
        ClassLoader contextClassloader = Thread.currentThread().getContextClassLoader();
        URL uRL = url = contextClassloader != null ? contextClassloader.getResource(path) : ConfigurationLoader.class.getResource(path);
        if (url != null) {
            return ConfigurationLoader.New(url, charset);
        }
        try {
            return ConfigurationLoader.New(new URL(path), charset);
        }
        catch (MalformedURLException e) {
            File file = new File(path);
            if (file.exists()) {
                return ConfigurationLoader.New(file, charset);
            }
            throw new ConfigurationExceptionNoConfigurationFound("No configuration found at: " + path);
        }
    }

    public static ConfigurationLoader New(Path path) {
        return ConfigurationLoader.New(path, Defaults.defaultCharset());
    }

    public static ConfigurationLoader New(Path path, Charset charset) {
        return new PathLoader((Path)X.notNull((Object)path), (Charset)X.notNull((Object)charset));
    }

    public static ConfigurationLoader New(File file) {
        return ConfigurationLoader.New(file, Defaults.defaultCharset());
    }

    public static ConfigurationLoader New(File file, Charset charset) {
        return new FileLoader((File)X.notNull((Object)file), (Charset)X.notNull((Object)charset));
    }

    public static ConfigurationLoader New(URL url) {
        return ConfigurationLoader.New(url, Defaults.defaultCharset());
    }

    public static ConfigurationLoader New(URL url, Charset charset) {
        return new UrlLoader((URL)X.notNull((Object)url), (Charset)X.notNull((Object)charset));
    }

    public static ConfigurationLoader New(InputStream inputStream) {
        return ConfigurationLoader.New(inputStream, Defaults.defaultCharset());
    }

    public static ConfigurationLoader New(InputStream inputStream, Charset charset) {
        return new InputStreamLoader((InputStream)X.notNull((Object)inputStream), (Charset)X.notNull((Object)charset));
    }

    public static class FileLoader
    implements ConfigurationLoader {
        private static final Logger logger = Logging.getLogger(ConfigurationLoader.class);
        private final File file;
        private final Charset charset;

        FileLoader(File file, Charset charset) {
            this.file = file;
            this.charset = charset;
        }

        @Override
        public String loadConfiguration() {
            String string;
            logger.info("Loading configuration: {} ({})", (Object)this.file.getAbsolutePath(), (Object)this.charset.displayName());
            FileInputStream in = new FileInputStream(this.file);
            try {
                string = XChars.readStringFromInputStream((InputStream)in, (Charset)this.charset);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
            ((InputStream)in).close();
            return string;
        }
    }

    public static class PathLoader
    implements ConfigurationLoader {
        private static final Logger logger = Logging.getLogger(ConfigurationLoader.class);
        private final Path path;
        private final Charset charset;

        PathLoader(Path path, Charset charset) {
            this.path = path;
            this.charset = charset;
        }

        @Override
        public String loadConfiguration() {
            String string;
            block8: {
                logger.info("Loading configuration: {} ({})", (Object)this.path.toAbsolutePath().toString(), (Object)this.charset.displayName());
                InputStream in = Files.newInputStream(this.path, new OpenOption[0]);
                try {
                    string = XChars.readStringFromInputStream((InputStream)in, (Charset)this.charset);
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IORuntimeException(e);
                    }
                }
                in.close();
            }
            return string;
        }
    }

    public static class UrlLoader
    implements ConfigurationLoader {
        private static final Logger logger = Logging.getLogger(ConfigurationLoader.class);
        private final URL url;
        private final Charset charset;

        UrlLoader(URL url, Charset charset) {
            this.url = url;
            this.charset = charset;
        }

        @Override
        public String loadConfiguration() {
            String string;
            block8: {
                logger.info("Loading configuration: {} ({})", (Object)this.url.toExternalForm(), (Object)this.charset.displayName());
                InputStream in = this.url.openStream();
                try {
                    string = XChars.readStringFromInputStream((InputStream)in, (Charset)this.charset);
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IORuntimeException(e);
                    }
                }
                in.close();
            }
            return string;
        }
    }

    public static class InputStreamLoader
    implements ConfigurationLoader {
        private static final Logger logger = Logging.getLogger(ConfigurationLoader.class);
        private final InputStream inputStream;
        private final Charset charset;

        InputStreamLoader(InputStream inputStream, Charset charset) {
            this.inputStream = inputStream;
            this.charset = charset;
        }

        @Override
        public String loadConfiguration() {
            logger.info("Loading configuration: {} ({})", (Object)this.inputStream, (Object)this.charset.displayName());
            try {
                return XChars.readStringFromInputStream((InputStream)this.inputStream, (Charset)this.charset);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static interface Defaults {
        public static Charset defaultCharset() {
            return StandardCharsets.UTF_8;
        }
    }
}

