/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.configuration.types;

import org.eclipse.serializer.configuration.types.ByteSizeParser;
import org.eclipse.serializer.configuration.types.ByteUnit;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.util.X;

public interface ByteSize
extends Comparable<ByteSize> {
    public double amount();

    public ByteUnit unit();

    public long bytes();

    public String toString();

    public static ByteSize New(String value) {
        return ByteSizeParser.New().parse(value);
    }

    public static ByteSize New(double amount, ByteUnit unit) {
        return new Default(XMath.notNegative((double)amount), (ByteUnit)((Object)X.notNull((Object)((Object)unit))));
    }

    public static class Default
    implements ByteSize {
        private final double amount;
        private final ByteUnit unit;
        private final long bytes;

        Default(double amount, ByteUnit unit) {
            this.amount = amount;
            this.unit = unit;
            this.bytes = unit.toBytes(amount);
        }

        @Override
        public double amount() {
            return this.amount;
        }

        @Override
        public ByteUnit unit() {
            return this.unit;
        }

        @Override
        public long bytes() {
            return this.bytes;
        }

        @Override
        public int compareTo(ByteSize other) {
            return Long.compare(this.bytes, other.bytes());
        }

        public int hashCode() {
            return Long.hashCode(this.bytes);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ByteSize)) {
                return false;
            }
            ByteSize other = (ByteSize)obj;
            return this.bytes == other.bytes();
        }

        @Override
        public String toString() {
            return XMath.isMathematicalInteger((double)this.amount) ? Long.toString((long)this.amount) + this.unit.name() : Double.toString(this.amount) + this.unit.name();
        }
    }
}

