/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.configuration.types;

import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.configuration.exceptions.ConfigurationException;
import org.eclipse.serializer.configuration.types.Configuration;
import org.eclipse.serializer.configuration.types.ConfigurationAssembler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface ConfigurationAssemblerXml
extends ConfigurationAssembler {
    public static ConfigurationAssemblerXml New() {
        return new Default();
    }

    public static class Default
    implements ConfigurationAssemblerXml {
        Default() {
        }

        @Override
        public VarString assemble(VarString vs, Configuration configuration) {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element rootElement = document.createElement("configuration");
                document.appendChild(rootElement);
                this.assemble(document, rootElement, configuration);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.transform(new DOMSource(document), new StreamResult(new VarStringWriter(vs)));
            }
            catch (ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError e) {
                throw new ConfigurationException(configuration, e);
            }
            return vs;
        }

        private void assemble(Document document, Element parent, Configuration configuration) {
            configuration.keys().forEach(key -> {
                Element element = document.createElement((String)key);
                element.appendChild(document.createTextNode(configuration.get((String)key)));
                parent.appendChild(element);
            });
            configuration.children().forEach(child -> {
                Element element = document.createElement(child.key());
                parent.appendChild(element);
                this.assemble(document, element, (Configuration)child);
            });
        }

        static class VarStringWriter
        extends Writer {
            final VarString vs;

            VarStringWriter(VarString vs) {
                this.vs = vs;
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.vs.add(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }
    }
}

