/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.java.lang;

import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustom;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import org.eclipse.serializer.util.X;

public abstract class AbstractBinaryHandlerAbstractStringBuilder<B>
extends AbstractBinaryHandlerCustom<B> {
    protected static final long LENGTH_CAPACITY = 8L;
    protected static final long OFFSET_CAPACITY = 0L;
    protected static final long OFFSET_CHARS = 8L;

    public AbstractBinaryHandlerAbstractStringBuilder(Class<B> type) {
        super(type, (XGettingSequence<? extends PersistenceTypeDefinitionMember>)AbstractBinaryHandlerAbstractStringBuilder.CustomFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{AbstractBinaryHandlerAbstractStringBuilder.CustomField(Long.TYPE, "capacity"), AbstractBinaryHandlerAbstractStringBuilder.chars("value")}));
    }

    protected final void storeData(Binary data, char[] chars, int capacity, long objectId, PersistenceStoreHandler<Binary> handler) {
        long contentLength = Binary.toBinaryListTotalByteLength(8L + (long)chars.length * 2L);
        data.storeEntityHeader(contentLength, this.typeId(), objectId);
        data.store_long(0L, capacity);
        data.storeCharsAsList(8L, chars, 0, chars.length);
    }

    protected final int readCapacity(Binary data) {
        return X.checkArrayRange((long)data.read_long(0L));
    }

    protected final char[] readChars(Binary data) {
        return data.build_chars(8L);
    }

    public final boolean hasPersistedReferences() {
        return false;
    }

    public final boolean hasPersistedVariableLength() {
        return true;
    }

    public final boolean hasVaryingPersistedLengthInstances() {
        return false;
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
    }
}

