/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.java.util;

import java.util.Comparator;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.eclipse.serializer.collections.old.KeyValueFlatCollector;
import org.eclipse.serializer.collections.old.OldCollections;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustomCollection;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdAcceptor;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import org.eclipse.serializer.util.X;

public final class BinaryHandlerTreeMap
extends AbstractBinaryHandlerCustomCollection<TreeMap<?, ?>> {
    static final long BINARY_OFFSET_COMPARATOR = 0L;
    static final long BINARY_OFFSET_ELEMENTS = 0L + (long)Binary.objectIdByteLength();

    private static Class<TreeMap<?, ?>> handledType() {
        return TreeMap.class;
    }

    static final int getElementCount(Binary data) {
        return X.checkArrayRange((long)data.getListElementCountKeyValue(BINARY_OFFSET_ELEMENTS));
    }

    private static <E> Comparator<? super E> getComparator(Binary data, PersistenceLoadHandler handler) {
        return (Comparator)handler.lookupObject(data.read_long(0L));
    }

    public static BinaryHandlerTreeMap New() {
        return new BinaryHandlerTreeMap();
    }

    BinaryHandlerTreeMap() {
        super(BinaryHandlerTreeMap.handledType(), (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)BinaryHandlerTreeMap.keyValuesFields(new PersistenceTypeDefinitionMemberFieldGeneric[]{BinaryHandlerTreeMap.CustomField(Comparator.class, "comparator")}));
    }

    @Override
    public final void store(Binary data, TreeMap<?, ?> instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeMapEntrySet(this.typeId(), objectId, BINARY_OFFSET_ELEMENTS, instance.entrySet(), (PersistenceFunction)handler);
        data.store_long(0L, handler.apply(instance.comparator()));
    }

    @Override
    public final TreeMap<?, ?> create(Binary data, PersistenceLoadHandler handler) {
        return new TreeMap(BinaryHandlerTreeMap.getComparator(data, handler));
    }

    public final void updateState(Binary data, TreeMap<?, ?> instance, PersistenceLoadHandler handler) {
        instance.clear();
        int elementCount = BinaryHandlerTreeMap.getElementCount(data);
        KeyValueFlatCollector collector = KeyValueFlatCollector.New((int)elementCount);
        data.collectKeyValueReferences(BINARY_OFFSET_ELEMENTS, elementCount, handler, (BiConsumer<Object, Object>)collector);
        data.registerHelper(instance, collector.yield());
    }

    @Override
    public final void complete(Binary data, TreeMap<?, ?> instance, PersistenceLoadHandler handler) {
        OldCollections.populateMapFromHelperArray(instance, (Object)data.getHelper(instance));
    }

    @Override
    public final void iterateInstanceReferences(TreeMap<?, ?> instance, PersistenceFunction iterator) {
        iterator.apply(instance.comparator());
        Persistence.iterateReferencesMap((PersistenceFunction)iterator, instance);
    }

    public final void iterateLoadableReferences(Binary data, PersistenceReferenceLoader iterator) {
        iterator.acceptObjectId(data.read_long(0L));
        data.iterateKeyValueEntriesReferences(BINARY_OFFSET_ELEMENTS, (PersistenceObjectIdAcceptor)iterator);
    }
}

