/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.HashEnum;
import org.eclipse.serializer.collections.HashTable;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingMap;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryLegacyTypeHandlerReflective;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryLegacyTypeHandlerGenericEnum;
import org.eclipse.serializer.persistence.binary.types.BinaryLegacyTypeHandlerGenericEnumMapped;
import org.eclipse.serializer.persistence.binary.types.BinaryLegacyTypeHandlerGenericType;
import org.eclipse.serializer.persistence.binary.types.BinaryLegacyTypeHandlerRerouting;
import org.eclipse.serializer.persistence.binary.types.BinaryValueSetter;
import org.eclipse.serializer.persistence.binary.types.BinaryValueTranslatorProvider;
import org.eclipse.serializer.persistence.types.PersistenceLegacyTypeHandler;
import org.eclipse.serializer.persistence.types.PersistenceLegacyTypeHandlerCreator;
import org.eclipse.serializer.persistence.types.PersistenceLegacyTypeHandlerWrapperEnum;
import org.eclipse.serializer.persistence.types.PersistenceLegacyTypeHandlingListener;
import org.eclipse.serializer.persistence.types.PersistenceLegacyTypeMappingResult;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldReflective;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandlerReflective;
import org.eclipse.serializer.reflect.XReflect;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.similarity.Similarity;

public interface BinaryLegacyTypeHandlerCreator
extends PersistenceLegacyTypeHandlerCreator<Binary> {
    public static BinaryLegacyTypeHandlerCreator New(BinaryValueTranslatorProvider valueTranslatorProvider, PersistenceLegacyTypeHandlingListener<Binary> legacyTypeHandlingListener, boolean switchByteOrder) {
        return new Default((BinaryValueTranslatorProvider)X.notNull((Object)valueTranslatorProvider), (PersistenceLegacyTypeHandlingListener<Binary>)((PersistenceLegacyTypeHandlingListener)X.mayNull(legacyTypeHandlingListener)), switchByteOrder);
    }

    public static final class Default
    extends PersistenceLegacyTypeHandlerCreator.Abstract<Binary>
    implements BinaryLegacyTypeHandlerCreator {
        private final BinaryValueTranslatorProvider valueTranslatorProvider;
        private final PersistenceLegacyTypeHandlingListener<Binary> legacyTypeHandlingListener;
        private final boolean switchByteOrder;

        Default(BinaryValueTranslatorProvider valueTranslatorProvider, PersistenceLegacyTypeHandlingListener<Binary> legacyTypeHandlingListener, boolean switchByteOrder) {
            this.valueTranslatorProvider = valueTranslatorProvider;
            this.legacyTypeHandlingListener = legacyTypeHandlingListener;
            this.switchByteOrder = switchByteOrder;
        }

        private static HashTable<PersistenceTypeDefinitionMember, Long> createBinaryOffsetMap(XGettingEnum<? extends PersistenceTypeDefinitionMember> members) {
            HashTable memberOffsets = HashTable.New();
            long totalOffset = 0L;
            for (PersistenceTypeDefinitionMember member : members) {
                memberOffsets.add((Object)member, (Object)totalOffset);
                totalOffset += member.persistentMaximumLength();
            }
            return memberOffsets;
        }

        private static HashTable<PersistenceTypeDefinitionMember, Long> createFieldOffsetMap(Class<?> entityClass, XGettingEnum<? extends PersistenceTypeDefinitionMemberFieldReflective> members) {
            Field[] fields = (Field[])((BulkList)PersistenceTypeDefinitionMemberFieldReflective.unbox(members, (Consumer)BulkList.New())).toArray(Field.class);
            long[] offsets = XMemory.objectFieldOffsets(entityClass, (Field[])fields);
            HashTable memberOffsets = HashTable.New();
            int i = 0;
            for (PersistenceTypeDefinitionMemberFieldReflective member : members) {
                memberOffsets.add((Object)member, (Object)offsets[i++]);
            }
            return memberOffsets;
        }

        private XGettingEnum<KeyValue<Long, BinaryValueSetter>> deriveValueTranslators(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<Binary, ?> currentTypeHandler, XGettingMap<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> legacyToTargetMembers, HashTable<PersistenceTypeDefinitionMember, Long> targetMemberOffsets, boolean resolveReferences) {
            HashEnum translatorsWithTargetOffsets = HashEnum.New();
            BinaryValueTranslatorProvider creator = this.valueTranslatorProvider;
            for (PersistenceTypeDefinitionMember legacyMember : legacyTypeDefinition.instanceMembers()) {
                PersistenceTypeDefinitionMember currentMember = (PersistenceTypeDefinitionMember)Similarity.targetElement((Similarity)((Similarity)legacyToTargetMembers.get((Object)legacyMember)));
                BinaryValueSetter translator = resolveReferences ? creator.provideTargetValueTranslator(legacyTypeDefinition, legacyMember, currentTypeHandler, currentMember) : creator.provideBinaryValueTranslator(legacyTypeDefinition, legacyMember, currentTypeHandler, currentMember);
                Long targetOffset = (Long)targetMemberOffsets.get((Object)currentMember);
                translatorsWithTargetOffsets.add((Object)X.KeyValue((Object)targetOffset, (Object)translator));
            }
            return translatorsWithTargetOffsets;
        }

        protected <T> PersistenceLegacyTypeHandler<Binary, T> deriveCustomWrappingHandler(PersistenceLegacyTypeMappingResult<Binary, T> mappingResult) {
            PersistenceTypeHandler currentTypeHandler = mappingResult.currentTypeHandler();
            if (currentTypeHandler.hasPersistedVariableLength()) {
                throw new UnsupportedOperationException("Types with varying persisted length are not supported, yet by generic mapping. Use a custom handler for type" + currentTypeHandler.toRuntimeTypeIdentifier());
            }
            HashTable<PersistenceTypeDefinitionMember, Long> targetMemberOffsets = Default.createBinaryOffsetMap((XGettingEnum<? extends PersistenceTypeDefinitionMember>)mappingResult.currentTypeHandler().instanceMembers());
            XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets = this.deriveValueTranslators(mappingResult.legacyTypeDefinition(), mappingResult.currentTypeHandler(), (XGettingMap<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)mappingResult.legacyToCurrentMembers(), targetMemberOffsets, false);
            BinaryLegacyTypeHandlerRerouting reroutingTypeHandler = BinaryLegacyTypeHandlerRerouting.New(mappingResult.legacyTypeDefinition(), currentTypeHandler, translatorsWithTargetOffsets, this.legacyTypeHandlingListener, this.switchByteOrder);
            if (XReflect.isEnum((Class)currentTypeHandler.type())) {
                return this.deriveCustomWrappingHandlerEnum(mappingResult, reroutingTypeHandler);
            }
            return reroutingTypeHandler;
        }

        protected <T> PersistenceLegacyTypeHandler<Binary, T> deriveCustomWrappingHandlerEnum(PersistenceLegacyTypeMappingResult<Binary, T> mappingResult, BinaryLegacyTypeHandlerRerouting<T> reroutingTypeHandler) {
            if (PersistenceLegacyTypeMappingResult.isUnchangedStaticStructure(mappingResult)) {
                return reroutingTypeHandler;
            }
            Integer[] ordinalMapping = Default.deriveEnumOrdinalMapping(mappingResult);
            return PersistenceLegacyTypeHandlerWrapperEnum.New((PersistenceTypeDefinition)mappingResult.legacyTypeDefinition(), reroutingTypeHandler, (Integer[])ordinalMapping);
        }

        protected <T> AbstractBinaryLegacyTypeHandlerReflective<T> deriveReflectiveHandler(PersistenceLegacyTypeMappingResult<Binary, T> mappingResult, PersistenceTypeHandlerReflective<Binary, T> currentTypeHandler) {
            HashTable<PersistenceTypeDefinitionMember, Long> targetMemberOffsets = Default.createFieldOffsetMap(currentTypeHandler.type(), (XGettingEnum<? extends PersistenceTypeDefinitionMemberFieldReflective>)currentTypeHandler.settingMembers());
            XGettingEnum<KeyValue<Long, BinaryValueSetter>> valueTranslators = this.deriveValueTranslators(mappingResult.legacyTypeDefinition(), mappingResult.currentTypeHandler(), (XGettingMap<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>>)mappingResult.legacyToCurrentMembers(), targetMemberOffsets, true);
            return XReflect.isEnum((Class)currentTypeHandler.type()) ? this.deriveReflectiveHandlerGenericEnum(mappingResult, (PersistenceTypeHandler<Binary, T>)currentTypeHandler, valueTranslators) : this.deriveReflectiveHandlerGenericType(mappingResult, currentTypeHandler, valueTranslators);
        }

        private <T> AbstractBinaryLegacyTypeHandlerReflective<T> deriveReflectiveHandlerGenericEnum(PersistenceLegacyTypeMappingResult<Binary, T> mappingResult, PersistenceTypeHandler<Binary, T> currentTypeHandler, XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets) {
            if (PersistenceLegacyTypeMappingResult.isUnchangedStaticStructure(mappingResult)) {
                return BinaryLegacyTypeHandlerGenericEnum.New(mappingResult.legacyTypeDefinition(), currentTypeHandler, translatorsWithTargetOffsets, this.legacyTypeHandlingListener, this.switchByteOrder);
            }
            Integer[] ordinalMapping = Default.deriveEnumOrdinalMapping(mappingResult);
            return BinaryLegacyTypeHandlerGenericEnumMapped.New(mappingResult.legacyTypeDefinition(), currentTypeHandler, translatorsWithTargetOffsets, ordinalMapping, this.legacyTypeHandlingListener, this.switchByteOrder);
        }

        private <T> BinaryLegacyTypeHandlerGenericType<T> deriveReflectiveHandlerGenericType(PersistenceLegacyTypeMappingResult<Binary, T> mappingResult, PersistenceTypeHandlerReflective<Binary, T> currentTypeHandler, XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets) {
            return BinaryLegacyTypeHandlerGenericType.New(mappingResult.legacyTypeDefinition(), currentTypeHandler, translatorsWithTargetOffsets, this.legacyTypeHandlingListener, this.switchByteOrder);
        }
    }
}

