/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import java.nio.ByteBuffer;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryLegacyTypeHandlerTranslating;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryReferenceTraverser;
import org.eclipse.serializer.persistence.binary.types.BinaryValueSetter;
import org.eclipse.serializer.persistence.types.PersistenceLegacyTypeHandlingListener;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdAcceptor;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;

public final class BinaryLegacyTypeHandlerRerouting<T>
extends AbstractBinaryLegacyTypeHandlerTranslating<T> {
    private final BinaryReferenceTraverser[] newBinaryLayoutReferenceTraversers;

    public static <T> BinaryLegacyTypeHandlerRerouting<T> New(PersistenceTypeDefinition typeDefinition, PersistenceTypeHandler<Binary, T> typeHandler, XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets, PersistenceLegacyTypeHandlingListener<Binary> listener, boolean switchByteOrder) {
        return new BinaryLegacyTypeHandlerRerouting<T>((PersistenceTypeDefinition)X.notNull((Object)typeDefinition), (PersistenceTypeHandler)X.notNull(typeHandler), BinaryLegacyTypeHandlerRerouting.toTranslators(translatorsWithTargetOffsets), BinaryLegacyTypeHandlerRerouting.toTargetOffsets(translatorsWithTargetOffsets), (PersistenceLegacyTypeHandlingListener<Binary>)((PersistenceLegacyTypeHandlingListener)X.mayNull(listener)), switchByteOrder);
    }

    BinaryLegacyTypeHandlerRerouting(PersistenceTypeDefinition typeDefinition, PersistenceTypeHandler<Binary, T> typeHandler, BinaryValueSetter[] valueTranslators, long[] targetOffsets, PersistenceLegacyTypeHandlingListener<Binary> listener, boolean switchByteOrder) {
        super(typeDefinition, typeHandler, valueTranslators, targetOffsets, listener, switchByteOrder);
        this.newBinaryLayoutReferenceTraversers = BinaryLegacyTypeHandlerRerouting.deriveReferenceTraversers(typeHandler, switchByteOrder);
    }

    public final void iterateLoadableReferences(Binary rawData, PersistenceReferenceLoader iterator) {
        rawData.iterateReferences(this.newBinaryLayoutReferenceTraversers, (PersistenceObjectIdAcceptor)iterator);
    }

    @Override
    protected T internalCreate(Binary rawData, PersistenceLoadHandler handler) {
        long entityContentLength = this.typeHandler().membersPersistedLengthMaximum();
        long entityTotalLength = Binary.entityTotalLength(entityContentLength);
        long entityTypeId = this.typeHandler().typeId();
        long entityObjectId = rawData.getBuildItemObjectId();
        ByteBuffer directByteBuffer = XMemory.allocateDirectNative((long)entityTotalLength);
        long entityOffset = 0L;
        long targetContentOffset = Binary.toEntityContentOffset(0L);
        rawData.copyMemory(directByteBuffer, targetContentOffset, this.valueTranslators(), this.targetOffsets());
        rawData.modifyLoadItem(directByteBuffer, 0L, entityTotalLength, entityTypeId, entityObjectId);
        rawData.registerHelper(directByteBuffer, directByteBuffer);
        Object instance = this.typeHandler().create((Object)rawData, handler);
        return (T)instance;
    }

    public final void updateState(Binary rawData, T instance, PersistenceLoadHandler handler) {
        this.typeHandler().updateState((Object)rawData, instance, handler);
    }

    public final void complete(Binary rawData, T instance, PersistenceLoadHandler handler) {
        this.typeHandler().complete((Object)rawData, instance, handler);
    }
}

