/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.java.math;

import java.math.BigInteger;
import java.util.Arrays;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustomValueVariableLength;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;

public final class BinaryHandlerBigInteger
extends AbstractBinaryHandlerCustomValueVariableLength<BigInteger, byte[]> {
    public static BinaryHandlerBigInteger New() {
        return new BinaryHandlerBigInteger();
    }

    BinaryHandlerBigInteger() {
        super(BigInteger.class, (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)BinaryHandlerBigInteger.CustomFields(BinaryHandlerBigInteger.bytes("value")));
    }

    private static byte[] instanceState(BigInteger instance) {
        return instance.toByteArray();
    }

    private static byte[] binaryState(Binary data) {
        return data.build_bytes();
    }

    @Override
    public void store(Binary data, BigInteger instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.store_bytes(this.typeId(), objectId, instance.toByteArray());
    }

    @Override
    public BigInteger create(Binary data, PersistenceLoadHandler handler) {
        return new BigInteger(data.build_bytes());
    }

    @Override
    public byte[] getValidationStateFromInstance(BigInteger instance) {
        return BinaryHandlerBigInteger.instanceState(instance);
    }

    @Override
    public byte[] getValidationStateFromBinary(Binary data) {
        return BinaryHandlerBigInteger.binaryState(data);
    }

    @Override
    public void validateState(Binary data, BigInteger instance, PersistenceLoadHandler handler) {
        byte[] binaryState;
        byte[] instanceState = BinaryHandlerBigInteger.instanceState(instance);
        if (Arrays.equals(instanceState, binaryState = BinaryHandlerBigInteger.binaryState(data))) {
            return;
        }
        this.throwInconsistentStateException(instance, Arrays.toString(instanceState), Arrays.toString(binaryState));
    }
}

