/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryLegacyTypeHandler;
import org.eclipse.serializer.persistence.binary.types.BinaryReferenceTraverser;
import org.eclipse.serializer.persistence.binary.types.BinaryValueSetter;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.exceptions.PersistenceExceptionTypeNotPersistable;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceLegacyTypeHandlingListener;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.cql.CQL;

public abstract class AbstractBinaryLegacyTypeHandlerTranslating<T>
extends BinaryLegacyTypeHandler.Abstract<T> {
    private final PersistenceTypeHandler<Binary, T> typeHandler;
    private final BinaryValueSetter[] valueTranslators;
    private final long[] targetOffsets;
    private final PersistenceLegacyTypeHandlingListener<Binary> listener;

    public static BinaryValueSetter[] toTranslators(XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets) {
        AbstractBinaryLegacyTypeHandlerTranslating.validate(translatorsWithTargetOffsets);
        return (BinaryValueSetter[])CQL.from(translatorsWithTargetOffsets).project(KeyValue::value).executeInto((Object[])new BinaryValueSetter[translatorsWithTargetOffsets.intSize()]);
    }

    public static long[] toTargetOffsets(XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets) {
        AbstractBinaryLegacyTypeHandlerTranslating.validate(translatorsWithTargetOffsets);
        return X.unbox((Long[])((Long[])CQL.from(translatorsWithTargetOffsets).project(kv -> {
            Long offset = (Long)kv.key();
            return offset == null ? -1L : offset;
        }).executeInto((Object[])new Long[translatorsWithTargetOffsets.intSize()])));
    }

    private static void validate(XGettingEnum<KeyValue<Long, BinaryValueSetter>> translatorsWithTargetOffsets) {
        Predicate<KeyValue> isNullEntry = e -> e.value() == null;
        if (translatorsWithTargetOffsets.containsSearched(isNullEntry)) {
            throw new PersistenceException("Value translator mapping contains an invalid null-entry.");
        }
    }

    public static final BinaryReferenceTraverser[] deriveReferenceTraversers(PersistenceTypeDefinition typeDefinition, boolean switchByteOrder) {
        BinaryReferenceTraverser[] referenceTraversers = BinaryReferenceTraverser.Static.deriveReferenceTraversers((XGettingSequence<? extends PersistenceTypeDescriptionMember>)typeDefinition.instanceMembers(), switchByteOrder);
        return BinaryReferenceTraverser.Static.cropToReferences(referenceTraversers);
    }

    protected AbstractBinaryLegacyTypeHandlerTranslating(PersistenceTypeDefinition typeDefinition, PersistenceTypeHandler<Binary, T> typeHandler, BinaryValueSetter[] valueTranslators, long[] targetOffsets, PersistenceLegacyTypeHandlingListener<Binary> listener, boolean switchByteOrder) {
        super(typeDefinition);
        this.typeHandler = typeHandler;
        this.valueTranslators = valueTranslators;
        this.targetOffsets = targetOffsets;
        this.listener = listener;
    }

    protected BinaryValueSetter[] valueTranslators() {
        return this.valueTranslators;
    }

    protected long[] targetOffsets() {
        return this.targetOffsets;
    }

    public PersistenceTypeHandler<Binary, T> typeHandler() {
        return this.typeHandler;
    }

    public XGettingEnum<? extends PersistenceTypeDefinitionMember> membersInDeclaredOrder() {
        return this.typeHandler.membersInDeclaredOrder();
    }

    public XGettingEnum<? extends PersistenceTypeDescriptionMember> storingMembers() {
        return this.typeHandler.storingMembers();
    }

    public XGettingEnum<? extends PersistenceTypeDescriptionMember> settingMembers() {
        return this.typeHandler.settingMembers();
    }

    public void guaranteeSpecificInstanceViablity() throws PersistenceExceptionTypeNotPersistable {
        this.typeHandler.guaranteeSpecificInstanceViablity();
    }

    public boolean isSpecificInstanceViable() {
        return this.typeHandler.isSpecificInstanceViable();
    }

    public void guaranteeSubTypeInstanceViablity() throws PersistenceExceptionTypeNotPersistable {
        this.typeHandler.guaranteeSubTypeInstanceViablity();
    }

    public boolean isSubTypeInstanceViable() {
        return this.typeHandler.isSubTypeInstanceViable();
    }

    public Object[] collectEnumConstants() {
        return null;
    }

    public int getPersistedEnumOrdinal(Binary data) {
        return this.typeHandler.getPersistedEnumOrdinal((Object)data);
    }

    public Class<T> type() {
        return this.typeHandler.type();
    }

    public void iterateInstanceReferences(T instance, PersistenceFunction iterator) {
        this.typeHandler.iterateInstanceReferences(instance, iterator);
    }

    public <C extends Consumer<? super Class<?>>> C iterateMemberTypes(C logic) {
        return (C)this.typeHandler.iterateMemberTypes(logic);
    }

    public final T create(Binary rawData, PersistenceLoadHandler handler) {
        return this.listener == null ? this.internalCreate(rawData, handler) : this.internalCreateListening(rawData, handler);
    }

    private final T internalCreateListening(Binary rawData, PersistenceLoadHandler handler) {
        T instance = this.internalCreate(rawData, handler);
        this.listener.registerLegacyTypeHandlingCreation(rawData.getBuildItemObjectId(), instance, this.legacyTypeDefinition(), this.typeHandler());
        return instance;
    }

    protected abstract T internalCreate(Binary var1, PersistenceLoadHandler var2);
}

