/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import java.lang.reflect.Field;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.exceptions.BinaryPersistenceException;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryFieldStorer;
import org.eclipse.serializer.persistence.binary.types.BinaryFieldStorerCreator;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;

public class BinaryFieldStorerThrowableStackTraceCreator
implements BinaryFieldStorerCreator<Throwable> {
    private Field field;

    public BinaryFieldStorerThrowableStackTraceCreator() {
        try {
            this.field = Throwable.class.getDeclaredField("stackTrace");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new BinaryPersistenceException("Failed to initialize filed storer!", e);
        }
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public BinaryFieldStorer<?> create(boolean isEager, boolean switchByteOrder) {
        if (isEager && switchByteOrder) {
            return new BinaryFieldStorerThrowableStackTrace_EAGER_REVERSED(this.field);
        }
        if (isEager) {
            return new BinaryFieldStorerThrowableStackTrace_EAGER(this.field);
        }
        if (switchByteOrder) {
            return new BinaryFieldStorerThrowableStackTrace_REVERSED(this.field);
        }
        return new BinaryFieldStorerThrowableStackTrace_DEFAULT(this.field);
    }

    public class BinaryFieldStorerThrowableStackTrace_EAGER_REVERSED
    extends AbstractBinaryFieldStorerThrowableStackTrace {
        public BinaryFieldStorerThrowableStackTrace_EAGER_REVERSED(Field field) {
            super(field);
        }

        @Override
        public void setObject(long targetAddress, PersistenceStoreHandler<Binary> persister, Object source, long sourceOffset) {
            XMemory.set_long((long)targetAddress, (long)Long.reverseBytes(persister.applyEager(XMemory.getObject((Object)source, (long)sourceOffset))));
        }
    }

    public class BinaryFieldStorerThrowableStackTrace_EAGER
    extends AbstractBinaryFieldStorerThrowableStackTrace {
        public BinaryFieldStorerThrowableStackTrace_EAGER(Field field) {
            super(field);
        }

        @Override
        public void setObject(long targetAddress, PersistenceStoreHandler<Binary> persister, Object source, long sourceOffset) {
            XMemory.set_long((long)targetAddress, (long)persister.applyEager(XMemory.getObject((Object)source, (long)sourceOffset)));
        }
    }

    public class BinaryFieldStorerThrowableStackTrace_REVERSED
    extends AbstractBinaryFieldStorerThrowableStackTrace {
        public BinaryFieldStorerThrowableStackTrace_REVERSED(Field field) {
            super(field);
        }

        @Override
        public void setObject(long targetAddress, PersistenceStoreHandler<Binary> persister, Object source, long sourceOffset) {
            XMemory.set_long((long)targetAddress, (long)Long.reverseBytes(persister.apply(XMemory.getObject((Object)source, (long)sourceOffset))));
        }
    }

    public class BinaryFieldStorerThrowableStackTrace_DEFAULT
    extends AbstractBinaryFieldStorerThrowableStackTrace {
        public BinaryFieldStorerThrowableStackTrace_DEFAULT(Field field) {
            super(field);
        }

        @Override
        public void setObject(long targetAddress, PersistenceStoreHandler<Binary> persister, Object source, long sourceOffset) {
            XMemory.set_long((long)targetAddress, (long)persister.apply(XMemory.getObject((Object)source, (long)sourceOffset)));
        }
    }

    public abstract class AbstractBinaryFieldStorerThrowableStackTrace
    implements BinaryFieldStorer<Throwable> {
        private final Field field;

        public abstract void setObject(long var1, PersistenceStoreHandler<Binary> var3, Object var4, long var5);

        public AbstractBinaryFieldStorerThrowableStackTrace(Field field) {
            this.field = field;
        }

        @Override
        public Field getField() {
            return this.field;
        }

        @Override
        public long storeValueFromMemory(Object source, long sourceOffset, long targetAddress, PersistenceStoreHandler<Binary> persister) {
            Throwable t = (Throwable)source;
            t.getStackTrace();
            this.setObject(targetAddress, persister, source, sourceOffset);
            return targetAddress + (long)Binary.objectIdByteLength();
        }
    }
}

