/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import org.eclipse.serializer.collections.Singleton;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerTrivial;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryHandlerGenericEnum;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberEnumConstant;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.reflect.XReflect;
import org.eclipse.serializer.util.X;

public final class BinaryHandlerSingletonStatelessEnum<T>
extends AbstractBinaryHandlerTrivial<T> {
    private final Singleton<PersistenceTypeDefinitionMemberEnumConstant> enumConstantMember;

    public static boolean isSingletonEnumType(Class<?> type) {
        return XReflect.isEnum(type) && type.getEnumConstants().length == 1;
    }

    public static <T> Class<T> validateIsSingletonEnumType(Class<T> type) {
        if (BinaryHandlerSingletonStatelessEnum.isSingletonEnumType(type)) {
            return type;
        }
        throw new IllegalArgumentException("Not a singleton Enum type: " + type);
    }

    public static <T extends Enum<T>> BinaryHandlerSingletonStatelessEnum<T> New(Class<?> type) {
        return new BinaryHandlerSingletonStatelessEnum<T>(XReflect.validateIsEnum(type));
    }

    protected BinaryHandlerSingletonStatelessEnum(Class<T> type) {
        super(BinaryHandlerSingletonStatelessEnum.validateIsSingletonEnumType(type));
        this.enumConstantMember = X.Singleton((Object)((PersistenceTypeDefinitionMemberEnumConstant)X.notNull((Object)((PersistenceTypeDefinitionMemberEnumConstant)BinaryHandlerGenericEnum.deriveEnumConstantMembers(type).get()))));
    }

    public final Object[] collectEnumConstants() {
        return Persistence.collectEnumConstants((PersistenceTypeHandler)this);
    }

    @Override
    public final XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers() {
        return this.enumConstantMember;
    }

    public final void store(Binary data, T instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeEntityHeader(0L, this.typeId(), objectId);
    }

    public final T create(Binary data, PersistenceLoadHandler handler) {
        return XReflect.getDeclaredEnumClass((Class)this.type()).getEnumConstants()[0];
    }

    public final synchronized PersistenceTypeHandler<Binary, T> initialize(long typeId) {
        return super.initialize(typeId);
    }
}

