/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.java.util;

import java.util.Collection;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustomIterableSimpleListElements;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.util.X;

public abstract class AbstractBinaryHandlerCollection<T extends Collection<?>>
extends AbstractBinaryHandlerCustomIterableSimpleListElements<T> {
    public static final void populateCollectionFromHelperArray(Collection<?> instance, Object elementsHelper) {
        if (elementsHelper == null) {
            throw new RuntimeException("Missing collection elements helper instance for " + XChars.systemString(instance));
        }
        if (!(elementsHelper instanceof Object[])) {
            throw new RuntimeException("Invalid collection elements helper instance for " + XChars.systemString(instance));
        }
        Collection<Object> castedInstance = instance;
        AbstractBinaryHandlerCollection.populateCollection(castedInstance, (Object[])elementsHelper);
    }

    public static final void populateCollection(Collection<Object> instance, Object[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (instance.add(elements[i])) continue;
            throw new RuntimeException("Error in adding logic (e.g. element hashing inconsistency) in " + XChars.systemString(instance));
        }
    }

    public AbstractBinaryHandlerCollection(Class<T> type) {
        super(type);
    }

    @Override
    protected long getElementCount(T instance) {
        return instance.size();
    }

    public void updateState(Binary data, T instance, PersistenceLoadHandler handler) {
        instance.clear();
        Object[] elementsHelper = new Object[X.checkArrayRange((long)AbstractBinaryHandlerCollection.getElementCount(data))];
        data.collectElementsIntoArray(this.binaryOffsetElements(), handler, elementsHelper);
        data.registerHelper(instance, elementsHelper);
    }

    @Override
    public void complete(Binary data, T instance, PersistenceLoadHandler handler) {
        AbstractBinaryHandlerCollection.populateCollectionFromHelperArray(instance, data.getHelper(instance));
    }
}

