/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.java.util;

import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.KeyValueFlatCollector;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.persistence.binary.types.AbstractBinaryHandlerCustomCollection;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdAcceptor;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldGeneric;
import org.eclipse.serializer.util.X;

public abstract class AbstractBinaryHandlerMap<T extends Map<?, ?>>
extends AbstractBinaryHandlerCustomCollection<T> {
    static final long BINARY_OFFSET_ELEMENTS = 0L;

    public static final long getElementCount(Binary data) {
        return data.getListElementCountKeyValue(0L);
    }

    public static final void populateMapFromHelperArray(Map<?, ?> instance, Object elementsHelper) {
        if (elementsHelper == null) {
            throw new RuntimeException("Missing collection elements helper instance for " + XChars.systemString(instance));
        }
        if (!(elementsHelper instanceof Object[])) {
            throw new RuntimeException("Invalid collection elements helper instance for " + XChars.systemString(instance));
        }
        Map<Object, Object> castedInstance = instance;
        AbstractBinaryHandlerMap.populateMap(castedInstance, (Object[])elementsHelper);
    }

    public static final void populateMap(Map<Object, Object> instance, Object[] elements) {
        for (int i = 0; i < elements.length; i += 2) {
            if (instance.putIfAbsent(elements[i], elements[i + 1]) == null) continue;
            throw new RuntimeException("Element hashing inconsistency in " + XChars.systemString(instance));
        }
    }

    public AbstractBinaryHandlerMap(Class<T> type) {
        super(type, (XGettingSequence<? extends PersistenceTypeDefinitionMemberFieldGeneric>)AbstractBinaryHandlerMap.keyValuesFields(new PersistenceTypeDefinitionMemberFieldGeneric[0]));
    }

    @Override
    public void store(Binary data, T instance, long objectId, PersistenceStoreHandler<Binary> handler) {
        data.storeMapEntrySet(this.typeId(), objectId, 0L, instance.entrySet(), (PersistenceFunction)handler);
    }

    public void updateState(Binary data, T instance, PersistenceLoadHandler handler) {
        instance.clear();
        int elementCount = X.checkArrayRange((long)AbstractBinaryHandlerMap.getElementCount(data));
        KeyValueFlatCollector collector = KeyValueFlatCollector.New((int)elementCount);
        data.collectKeyValueReferences(0L, elementCount, handler, (BiConsumer<Object, Object>)collector);
        data.registerHelper(instance, collector.yield());
    }

    @Override
    public void complete(Binary data, T instance, PersistenceLoadHandler handler) {
        AbstractBinaryHandlerMap.populateMapFromHelperArray(instance, data.getHelper(instance));
    }

    @Override
    public void iterateInstanceReferences(T instance, PersistenceFunction iterator) {
        Persistence.iterateReferencesMap((PersistenceFunction)iterator, instance);
    }

    public void iterateLoadableReferences(Binary data, PersistenceReferenceLoader loader) {
        data.iterateKeyValueEntriesReferences(0L, (PersistenceObjectIdAcceptor)loader);
    }
}

