/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.binders;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.sisu.locators.BeanLocator;
import org.eclipse.sisu.locators.ProviderIterableAdapter;
import org.eclipse.sisu.reflect.TypeParameters;

class AbstractBeans<K extends Annotation, V> {
    @Inject
    private BeanLocator locator;
    private final Key<?> key;
    private final boolean isProvider;

    AbstractBeans(Key<V> key) {
        TypeLiteral type = key.getTypeLiteral();
        Class clazz = type.getRawType();
        this.isProvider = Provider.class == clazz || com.google.inject.Provider.class == clazz;
        this.key = this.isProvider ? key.ofType(TypeParameters.get(type, 0)) : key;
    }

    protected final Iterable<Map.Entry<K, V>> beans() {
        ProviderIterableAdapter beans = this.locator.locate(this.key);
        return this.isProvider ? new ProviderIterableAdapter(beans) : beans;
    }
}

