/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.locators;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.locators.DefaultRankingFunction;
import org.eclipse.sisu.locators.ImplicitBindings;
import org.eclipse.sisu.locators.InjectorPublisher;
import org.eclipse.sisu.locators.LocatedBeans;
import org.eclipse.sisu.locators.MutableBeanLocator;
import org.eclipse.sisu.locators.RankedBindings;
import org.eclipse.sisu.locators.RankedSequence;
import org.eclipse.sisu.locators.RankingFunction;
import org.eclipse.sisu.locators.WatchedBeans;
import org.eclipse.sisu.locators.spi.BindingPublisher;
import org.eclipse.sisu.reflect.Logs;
import org.eclipse.sisu.reflect.Soft;
import org.eclipse.sisu.reflect.TypeParameters;
import org.eclipse.sisu.reflect.Weak;

@Singleton
public final class DefaultBeanLocator
extends ReentrantLock
implements MutableBeanLocator {
    private static final long serialVersionUID = 1L;
    private final RankedSequence<BindingPublisher> publishers = new RankedSequence();
    private final ConcurrentMap<TypeLiteral, RankedBindings> cachedBindings = Soft.concurrentValues(256, 8);
    private final Map<WatchedBeans, Object> cachedWatchers = Weak.values();
    private final ImplicitBindings implicitBindings = new ImplicitBindings(this.publishers);

    public Iterable<BeanEntry> locate(Key key) {
        TypeLiteral type = key.getTypeLiteral();
        RankedBindings bindings = (RankedBindings)this.cachedBindings.get(type);
        if (bindings == null) {
            this.lock();
            try {
                bindings = new RankedBindings(type, this.publishers);
                RankedBindings oldBindings = this.cachedBindings.putIfAbsent(type, bindings);
                if (oldBindings != null) {
                    bindings = oldBindings;
                }
            }
            finally {
                this.unlock();
            }
        }
        boolean isImplicit = key.getAnnotationType() == null && TypeParameters.isImplicit(type);
        return new LocatedBeans(key, bindings, isImplicit ? this.implicitBindings : null);
    }

    public void watch(Key key, Mediator mediator, Object watcher) {
        this.lock();
        try {
            WatchedBeans beans = new WatchedBeans(key, mediator, watcher);
            for (BindingPublisher p : this.publishers.snapshot()) {
                p.subscribe(beans);
            }
            this.cachedWatchers.put(beans, watcher);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void add(BindingPublisher publisher, int rank) {
        this.lock();
        try {
            if (!this.publishers.contains(publisher)) {
                Logs.debug("Add publisher: {}", publisher, null);
                this.publishers.insert(publisher, rank);
                for (RankedBindings bindings : this.cachedBindings.values()) {
                    bindings.add(publisher, rank);
                }
                for (WatchedBeans beans : this.cachedWatchers.keySet()) {
                    publisher.subscribe(beans);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void remove(BindingPublisher publisher) {
        this.lock();
        try {
            if (this.publishers.remove(publisher)) {
                Logs.debug("Remove publisher: {}", publisher, null);
                for (RankedBindings bindings : this.cachedBindings.values()) {
                    bindings.remove(publisher);
                }
                for (WatchedBeans beans : this.cachedWatchers.keySet()) {
                    publisher.unsubscribe(beans);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock();
        try {
            for (BindingPublisher p : this.publishers.snapshot()) {
                this.remove(p);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void add(Injector injector, int rank) {
        this.add(new InjectorPublisher(injector, new DefaultRankingFunction(rank)), rank);
    }

    @Override
    public void remove(Injector injector) {
        this.remove(new InjectorPublisher(injector, null));
    }

    @Inject
    void autoPublish(Injector injector) {
        DefaultBeanLocator.staticAutoPublish(this, injector);
    }

    @Inject
    static void staticAutoPublish(MutableBeanLocator locator, Injector injector) {
        RankingFunction function = (RankingFunction)injector.getInstance(RankingFunction.class);
        locator.add(new InjectorPublisher(injector, function), function.maxRank());
    }
}

