/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.locators;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import org.eclipse.sisu.locators.Implicit;
import org.eclipse.sisu.locators.InjectorPublisher;
import org.eclipse.sisu.locators.spi.BindingPublisher;
import org.eclipse.sisu.reflect.Logs;

final class ImplicitBindings {
    private final Iterable<BindingPublisher> publishers;

    ImplicitBindings(Iterable<BindingPublisher> publishers) {
        this.publishers = publishers;
    }

    public <T> Binding<T> get(TypeLiteral<T> type) {
        Key implicitKey = Key.get((Class)type.getRawType(), Implicit.class);
        for (BindingPublisher p : this.publishers) {
            Injector i;
            Binding binding;
            if (!(p instanceof InjectorPublisher) || (binding = (Binding)(i = ((InjectorPublisher)p).getInjector()).getBindings().get(implicitKey)) == null) continue;
            Logs.debug("Using implicit binding: {} from: <>", binding, i);
            return binding;
        }
        Key justInTimeKey = Key.get(type);
        for (BindingPublisher p : this.publishers) {
            if (!(p instanceof InjectorPublisher)) continue;
            Injector i = ((InjectorPublisher)p).getInjector();
            try {
                Binding binding = i.getBinding(justInTimeKey);
                if (!InjectorPublisher.isVisible(binding)) continue;
                Logs.debug("Using just-in-time binding: {} from: <>", binding, i);
                return binding;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (LinkageError linkageError) {}
        }
        return null;
    }
}

