/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.locators;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.BindingTargetVisitor;
import java.lang.annotation.Annotation;
import org.eclipse.sisu.locators.ImplementationVisitor;
import org.eclipse.sisu.locators.WildcardKey;

enum QualifyingStrategy {
    UNRESTRICTED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier = 1.qualify(binding.getKey());
            return qualifier != null ? qualifier : BLANK_QUALIFIER;
        }
    }
    ,
    NAMED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier = 2.qualify(binding.getKey());
            return qualifier instanceof Named ? qualifier : null;
        }
    }
    ,
    NAMED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier = 3.qualify(binding.getKey());
            return requirement.getAnnotation().equals(qualifier) ? qualifier : null;
        }
    }
    ,
    MARKED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier;
            Class markerType = requirement.getAnnotationType();
            if (markerType.isInstance(qualifier = 4.qualify(binding.getKey()))) {
                return qualifier;
            }
            Class implementation = (Class)binding.acceptTargetVisitor((BindingTargetVisitor)ImplementationVisitor.THIS);
            return implementation != null ? (Annotation)implementation.getAnnotation(markerType) : null;
        }
    }
    ,
    MARKED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier = MARKED.qualifies(requirement, binding);
            return requirement.getAnnotation().equals(qualifier) ? qualifier : null;
        }
    };

    static final Annotation DEFAULT_QUALIFIER;
    static final Annotation BLANK_QUALIFIER;

    static {
        DEFAULT_QUALIFIER = Names.named((String)"default");
        BLANK_QUALIFIER = Names.named((String)"");
    }

    private QualifyingStrategy() {
    }

    abstract Annotation qualifies(Key<?> var1, Binding<?> var2);

    static final QualifyingStrategy selectFor(Key<?> key) {
        Class qualifierType = key.getAnnotationType();
        if (qualifierType == null) {
            return UNRESTRICTED;
        }
        if (Named.class == qualifierType) {
            return key.hasAttributes() ? NAMED_WITH_ATTRIBUTES : NAMED;
        }
        return key.hasAttributes() ? MARKED_WITH_ATTRIBUTES : MARKED;
    }

    static final Annotation qualify(Key<?> key) {
        if (key instanceof WildcardKey) {
            Annotation qualifier = ((WildcardKey)key).getQualifier();
            return qualifier != null ? qualifier : DEFAULT_QUALIFIER;
        }
        return key.getAnnotationType() != null ? key.getAnnotation() : DEFAULT_QUALIFIER;
    }

    /* synthetic */ QualifyingStrategy(String string, int n, QualifyingStrategy qualifyingStrategy) {
        this();
    }
}

