/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.scanners;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Qualifier;
import org.eclipse.sisu.reflect.ClassSpace;
import org.eclipse.sisu.scanners.ClassSpaceScanner;
import org.eclipse.sisu.scanners.EmptyClassVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

final class QualifierCache
extends EmptyClassVisitor {
    private static final String QUALIFIER_DESC = Type.getDescriptor(Qualifier.class);
    private static final Map<String, Boolean> cachedResults = new ConcurrentHashMap<String, Boolean>(32, 0.75f, 1);
    private boolean isQualified;

    QualifierCache() {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.isQualified |= QUALIFIER_DESC.equals(desc);
        return null;
    }

    boolean qualify(ClassSpace space, String desc) {
        Boolean result = cachedResults.get(desc);
        if (result == null) {
            this.isQualified = false;
            String name = desc.substring(1, desc.length() - 1);
            ClassSpaceScanner.accept(this, space.getResource(String.valueOf(name) + ".class"));
            cachedResults.put(desc, this.isQualified);
            return this.isQualified;
        }
        return result;
    }
}

