/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.sisu.inject.BeanBinder;
import org.eclipse.sisu.inject.BeanInjector;
import org.eclipse.sisu.inject.PropertyBinder;
import org.eclipse.sisu.inject.PropertyBinding;
import org.eclipse.sisu.reflect.BeanProperties;
import org.eclipse.sisu.reflect.BeanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanListener
implements TypeListener {
    private final BeanBinder beanBinder;

    public BeanListener(BeanBinder beanBinder) {
        this.beanBinder = beanBinder;
    }

    public <B> void hear(TypeLiteral<B> type, TypeEncounter<B> encounter) {
        PropertyBinder propertyBinder = this.beanBinder.bindBean(type, encounter);
        if (propertyBinder == null) {
            return;
        }
        ArrayList<PropertyBinding> bindings = new ArrayList<PropertyBinding>();
        HashSet<String> visited = new HashSet<String>();
        for (BeanProperty<Object> property : new BeanProperties(type.getRawType())) {
            String name = property.getName();
            if (!visited.add(name)) continue;
            try {
                PropertyBinding binding = propertyBinder.bindProperty(property);
                if (binding == PropertyBinder.LAST_BINDING) break;
                if (binding != null) {
                    bindings.add(binding);
                    continue;
                }
                visited.remove(name);
            }
            catch (RuntimeException e) {
                encounter.addError((Throwable)new ProvisionException("Error binding: " + property, (Throwable)e));
            }
        }
        if (bindings.size() > 0) {
            encounter.register(new BeanInjector(bindings));
        }
    }
}

