/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.DefaultRankingFunction;
import org.eclipse.sisu.inject.ImplicitBindings;
import org.eclipse.sisu.inject.InjectorPublisher;
import org.eclipse.sisu.inject.LocatedBeans;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.RankedBindings;
import org.eclipse.sisu.inject.RankedSequence;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.inject.Soft;
import org.eclipse.sisu.inject.TypeParameters;
import org.eclipse.sisu.inject.WatchedBeans;
import org.eclipse.sisu.inject.Weak;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class DefaultBeanLocator
extends ReentrantLock
implements MutableBeanLocator {
    private static final long serialVersionUID = 1L;
    private final RankedSequence<BindingPublisher> publishers = new RankedSequence();
    private final ConcurrentMap<TypeLiteral, RankedBindings> cachedBindings = Soft.concurrentValues(256, 8);
    private final Map<WatchedBeans, Object> cachedWatchers = Weak.values();
    private final ImplicitBindings implicitBindings = new ImplicitBindings(this.publishers);

    public Iterable<BeanEntry> locate(Key key) {
        TypeLiteral type = key.getTypeLiteral();
        RankedBindings bindings = (RankedBindings)this.cachedBindings.get(type);
        if (bindings == null) {
            this.lock();
            try {
                bindings = new RankedBindings(type, this.publishers);
                RankedBindings oldBindings = this.cachedBindings.putIfAbsent(type, bindings);
                if (oldBindings != null) {
                    bindings = oldBindings;
                }
            }
            finally {
                this.unlock();
            }
        }
        boolean isImplicit = key.getAnnotationType() == null && TypeParameters.isImplicit(type);
        return new LocatedBeans(key, bindings, isImplicit ? this.implicitBindings : null);
    }

    public void watch(Key key, Mediator mediator, Object watcher) {
        this.lock();
        try {
            WatchedBeans beans = new WatchedBeans(key, mediator, watcher);
            for (BindingPublisher p : this.publishers.snapshot()) {
                p.subscribe(beans);
            }
            this.cachedWatchers.put(beans, watcher);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void add(BindingPublisher publisher, int rank) {
        this.lock();
        try {
            if (!this.publishers.contains(publisher)) {
                Logs.trace("Add publisher: {}", publisher, null);
                this.publishers.insert(publisher, rank);
                for (RankedBindings bindings : this.cachedBindings.values()) {
                    bindings.add(publisher, rank);
                }
                for (WatchedBeans beans : this.cachedWatchers.keySet()) {
                    publisher.subscribe(beans);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void remove(BindingPublisher publisher) {
        this.lock();
        try {
            if (this.publishers.remove(publisher)) {
                Logs.trace("Remove publisher: {}", publisher, null);
                for (RankedBindings bindings : this.cachedBindings.values()) {
                    bindings.remove(publisher);
                }
                for (WatchedBeans beans : this.cachedWatchers.keySet()) {
                    publisher.unsubscribe(beans);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock();
        try {
            for (BindingPublisher p : this.publishers.snapshot()) {
                this.remove(p);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void add(Injector injector, int rank) {
        this.add(new InjectorPublisher(injector, new DefaultRankingFunction(rank)), rank);
    }

    @Override
    public void remove(Injector injector) {
        this.remove(new InjectorPublisher(injector, null));
    }

    @Inject
    void autoPublish(Injector injector) {
        DefaultBeanLocator.staticAutoPublish(this, injector);
    }

    @Inject
    static void staticAutoPublish(MutableBeanLocator locator, Injector injector) {
        RankingFunction function = (RankingFunction)injector.getInstance(RankingFunction.class);
        locator.add(new InjectorPublisher(injector, function), function.maxRank());
    }
}

