/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Scopes;
import com.google.inject.name.Named;
import com.google.inject.spi.BindingTargetVisitor;
import java.lang.annotation.Annotation;
import javax.inject.Provider;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Description;
import org.eclipse.sisu.inject.BeanDescription;
import org.eclipse.sisu.inject.ImplementationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LazyBeanEntry<Q extends Annotation, T>
implements BeanEntry<Q, T> {
    private final Q qualifier;
    final Binding<T> binding;
    private final Provider<T> provider;
    private final int rank;

    LazyBeanEntry(Q qualifier, Binding<T> binding, int rank) {
        this.qualifier = qualifier != null && Named.class == qualifier.annotationType() ? new JsrNamed((Named)qualifier) : qualifier;
        this.binding = binding;
        this.rank = rank;
        this.provider = Scopes.isSingleton(binding) ? binding.getProvider() : Scopes.SINGLETON.scope(binding.getKey(), binding.getProvider());
    }

    @Override
    public Q getKey() {
        return this.qualifier;
    }

    @Override
    public T getValue() {
        return (T)this.provider.get();
    }

    @Override
    public T setValue(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Provider<T> getProvider() {
        return this.binding.getProvider();
    }

    @Override
    public String getDescription() {
        Object source = this.binding.getSource();
        if (source instanceof BeanDescription) {
            return ((BeanDescription)source).getDescription();
        }
        Class<T> clazz = this.getImplementationClass();
        if (clazz != null) {
            Description description = clazz.getAnnotation(Description.class);
            if (description != null) {
                return description.value();
            }
            org.sonatype.inject.Description legacy = clazz.getAnnotation(org.sonatype.inject.Description.class);
            if (legacy != null) {
                return legacy.value();
            }
        }
        return null;
    }

    @Override
    public Class<T> getImplementationClass() {
        return (Class)this.binding.acceptTargetVisitor((BindingTargetVisitor)ImplementationVisitor.THIS);
    }

    @Override
    public Object getSource() {
        return this.binding.getSource();
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.getKey()).append('=');
        try {
            buf.append(this.getValue());
        }
        catch (RuntimeException e) {
            buf.append(e);
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsrNamed
    implements Named,
    javax.inject.Named {
        private final String value;

        JsrNamed(Named named) {
            this.value = named.value();
        }

        public String value() {
            return this.value;
        }

        public Class<? extends Annotation> annotationType() {
            return javax.inject.Named.class;
        }

        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (rhs instanceof Named) {
                return this.value.equals(((Named)rhs).value());
            }
            if (rhs instanceof javax.inject.Named) {
                return this.value.equals(((javax.inject.Named)rhs).value());
            }
            return false;
        }

        public String toString() {
            return "@" + javax.inject.Named.class.getName() + "(value=" + this.value + ")";
        }
    }
}

