/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import java.util.Arrays;
import java.util.List;
import org.eclipse.sisu.wire.ElementAnalyzer;
import org.eclipse.sisu.wire.FileTypeConverter;
import org.eclipse.sisu.wire.LocatorWiring;
import org.eclipse.sisu.wire.URLTypeConverter;
import org.eclipse.sisu.wire.Wiring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireModule
implements Module {
    private final List<Module> modules;

    public WireModule(Module ... modules) {
        this(Arrays.asList(modules));
    }

    public WireModule(List<Module> modules) {
        this.modules = modules;
    }

    public void configure(Binder binder) {
        ElementAnalyzer analyzer = this.getAnalyzer(binder);
        for (Module m : this.modules) {
            for (Element e : Elements.getElements((Module[])new Module[]{m})) {
                e.acceptVisitor((ElementVisitor)analyzer);
            }
        }
        analyzer.apply(this.wiring(binder));
    }

    protected Wiring wiring(Binder binder) {
        binder.install((Module)new FileTypeConverter());
        binder.install((Module)new URLTypeConverter());
        return new LocatorWiring(binder);
    }

    ElementAnalyzer getAnalyzer(Binder binder) {
        return new ElementAnalyzer(binder);
    }
}

