/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.sisu.bean.BeanLifecycle;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.BeanScheduler;
import org.eclipse.sisu.bean.LifecycleBuilder;
import org.eclipse.sisu.bean.PropertyBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LifecycleManager
extends BeanScheduler
implements BeanManager {
    private final LifecycleBuilder builder = new LifecycleBuilder();
    private final Map<Class<?>, BeanLifecycle> lifecycles = new ConcurrentHashMap();
    private final List<Object> stoppableBeans = new ArrayList<Object>();

    @Override
    public boolean manage(Class<?> clazz) {
        return this.buildLifecycle(clazz);
    }

    @Override
    public PropertyBinding manage(BeanProperty<?> property) {
        return null;
    }

    @Override
    public boolean manage(Object bean) {
        if (bean != null) {
            BeanLifecycle lifecycle = this.lifecycleFor(bean.getClass());
            if (lifecycle.isStoppable()) {
                this.pushStoppable(bean);
            }
            if (lifecycle.isStartable()) {
                this.schedule(bean);
            }
        }
        return true;
    }

    @Override
    public boolean unmanage(Object bean) {
        if (this.removeStoppable(bean)) {
            this.lifecycleFor(bean.getClass()).stop(bean);
        }
        return true;
    }

    @Override
    public boolean unmanage() {
        Object bean;
        while ((bean = this.popStoppable()) != null) {
            this.lifecycleFor(bean.getClass()).stop(bean);
        }
        return true;
    }

    @Override
    protected void activate(Object bean) {
        this.lifecycleFor(bean.getClass()).start(bean);
    }

    private boolean buildLifecycle(Class<?> clazz) {
        if (!this.lifecycles.containsKey(clazz)) {
            this.lifecycles.put(clazz, this.builder.build(clazz));
        }
        return this.lifecycles.get(clazz) != BeanLifecycle.NO_OP;
    }

    private BeanLifecycle lifecycleFor(Class<?> clazz) {
        BeanLifecycle lifecycle = this.lifecycles.get(clazz);
        return lifecycle != null ? lifecycle : BeanLifecycle.NO_OP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pushStoppable(Object bean) {
        List<Object> list = this.stoppableBeans;
        synchronized (list) {
            return this.stoppableBeans.add(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeStoppable(Object bean) {
        List<Object> list = this.stoppableBeans;
        synchronized (list) {
            return this.stoppableBeans.remove(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object popStoppable() {
        List<Object> list = this.stoppableBeans;
        synchronized (list) {
            int size = this.stoppableBeans.size();
            return size > 0 ? this.stoppableBeans.remove(size - 1) : null;
        }
    }
}

