/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.BindingSubscriber;
import org.eclipse.sisu.osgi.BindingTracker;
import org.eclipse.sisu.space.GlobberStrategy;
import org.eclipse.sisu.space.Tokens;
import org.osgi.framework.BundleContext;

public final class ServiceBindings
implements BindingPublisher {
    private final ConcurrentMap<String, BindingTracker<?>> trackers = new ConcurrentHashMap(16, 0.75f, 1);
    private final BundleContext context;
    private final String[] allowed;
    private final String[] ignored;
    private final int maxRank;

    public ServiceBindings(BundleContext context, String allow, String ignore, int maxRank) {
        this.context = context;
        this.maxRank = maxRank;
        this.allowed = ServiceBindings.parseGlobs(allow);
        this.ignored = ServiceBindings.parseGlobs(ignore);
    }

    public ServiceBindings(BundleContext context) {
        this(context, ServiceBindings.defaultAllow(), ServiceBindings.defaultIgnore(), Integer.MIN_VALUE);
    }

    public static String defaultAllow() {
        return System.getProperty(String.valueOf(ServiceBindings.class.getName()) + ".allow", "");
    }

    public static String defaultIgnore() {
        return System.getProperty(String.valueOf(ServiceBindings.class.getName()) + ".ignore", "");
    }

    @Override
    public <T> void subscribe(BindingSubscriber<T> subscriber) {
        String clazzName = subscriber.type().getRawType().getName();
        if (this.shouldTrack(clazzName)) {
            BindingTracker oldTracker;
            BindingTracker<T> tracker = (BindingTracker<T>)((Object)this.trackers.get(clazzName));
            if (tracker == null && (oldTracker = this.trackers.putIfAbsent(clazzName, tracker = new BindingTracker<T>(this.context, this.maxRank, clazzName))) != null) {
                tracker = oldTracker;
            }
            tracker.subscribe(subscriber);
        }
    }

    @Override
    public <T> void unsubscribe(BindingSubscriber<T> subscriber) {
        String clazzName = subscriber.type().getRawType().getName();
        BindingTracker tracker = (BindingTracker)((Object)this.trackers.get(clazzName));
        if (tracker != null) {
            tracker.unsubscribe(subscriber);
        }
    }

    @Override
    public int maxBindingRank() {
        return this.maxRank;
    }

    @Override
    public <T> T adapt(Class<T> type) {
        return null;
    }

    private boolean shouldTrack(String clazzName) {
        String[] stringArray = this.allowed;
        int n = this.allowed.length;
        int n2 = 0;
        while (n2 < n) {
            String allow = stringArray[n2];
            if (GlobberStrategy.PATTERN.matches(allow, clazzName)) {
                String[] stringArray2 = this.ignored;
                int n3 = this.ignored.length;
                int n4 = 0;
                while (n4 < n3) {
                    String ignore = stringArray2[n4];
                    if (GlobberStrategy.PATTERN.matches(ignore, clazzName)) {
                        return false;
                    }
                    ++n4;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String[] parseGlobs(String globs) {
        ArrayList<String> patterns = new ArrayList<String>();
        for (String glob : Tokens.splitByComma(globs)) {
            patterns.add(GlobberStrategy.PATTERN.compile(glob));
        }
        return patterns.toArray(new String[patterns.size()]);
    }
}

