/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Tokens {
    private Tokens() {
    }

    public static Iterable<String> splitByComma(final String text) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new TokenIterator(text, ',', true);
            }
        };
    }

    public static Iterable<String> splitByStar(final String text) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new TokenIterator(text, '*', false);
            }
        };
    }

    static final class TokenIterator
    implements Iterator<String> {
        private final String text;
        private final char separator;
        private final boolean trimming;
        private int tokenIndex;

        TokenIterator(String text, char separator, boolean trimming) {
            this.text = text;
            this.separator = separator;
            this.trimming = trimming;
            this.tokenIndex = this.nextToken(0);
        }

        @Override
        public boolean hasNext() {
            return this.tokenIndex < this.text.length();
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                int separatorIndex = this.nextSeparator(this.tokenIndex + 1);
                int tokenEnd = this.trimming ? this.trimBack(separatorIndex - 1) + 1 : separatorIndex;
                String token = this.text.substring(this.tokenIndex, tokenEnd);
                this.tokenIndex = this.nextToken(separatorIndex + 1);
                return token;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private int nextToken(int from) {
            int max = this.text.length();
            int i = from;
            while (i < max) {
                char c = this.text.charAt(i);
                if (!(c == this.separator || this.trimming && Character.isWhitespace(c))) {
                    return i;
                }
                ++i;
            }
            return max;
        }

        private int nextSeparator(int from) {
            int i = this.text.indexOf(this.separator, from);
            return i >= 0 ? i : this.text.length();
        }

        private int trimBack(int from) {
            int min = this.tokenIndex;
            int i = from;
            while (i > min) {
                if (!Character.isWhitespace(this.text.charAt(i))) {
                    return i;
                }
                --i;
            }
            return min;
        }
    }
}

