/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus.lifecycles;

import com.google.inject.spi.ProvisionListener;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Provider;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.eclipse.sisu.inject.PropertyBinding;
import org.eclipse.sisu.plexus.binders.PlexusBeanManager;
import org.eclipse.sisu.reflect.BeanProperty;
import org.eclipse.sisu.reflect.Logs;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlexusLifecycleManager
implements PlexusBeanManager,
ProvisionListener {
    private static final Class<?>[] LIFECYCLE_TYPES = new Class[]{LogEnabled.class, Contextualizable.class, Initializable.class, Startable.class, Disposable.class};
    private static final ThreadLocal<List<?>[]> pendingHolder = new ThreadLocal<List<?>[]>(){

        @Override
        protected List<?>[] initialValue() {
            return new List[1];
        }
    };
    private final List<Startable> startableBeans = new ArrayList<Startable>();
    private final List<Disposable> disposableBeans = new ArrayList<Disposable>();
    private final Logger consoleLogger = new ConsoleLogger();
    private final Provider<Context> plexusContextProvider;
    private final Provider<LoggerManager> plexusLoggerManagerProvider;
    private final Provider<?> slf4jLoggerFactoryProvider;

    public PlexusLifecycleManager(Provider<Context> plexusContextProvider, Provider<LoggerManager> plexusLoggerManagerProvider, Provider<?> slf4jLoggerFactoryProvider) {
        this.plexusContextProvider = plexusContextProvider;
        this.plexusLoggerManagerProvider = plexusLoggerManagerProvider;
        this.slf4jLoggerFactoryProvider = slf4jLoggerFactoryProvider;
    }

    @Override
    public boolean manage(Class<?> clazz) {
        for (Class<?> lifecycleType : LIFECYCLE_TYPES) {
            if (!lifecycleType.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public PropertyBinding manage(final BeanProperty property) {
        Class clazz = property.getType().getRawType();
        if ("org.slf4j.Logger".equals(clazz.getName())) {
            return new PropertyBinding(){

                public <B> void injectProperty(B bean) {
                    property.set(bean, PlexusLifecycleManager.this.getSLF4JLogger(bean));
                }
            };
        }
        if (Logger.class.equals((Object)clazz)) {
            return new PropertyBinding(){

                public <B> void injectProperty(B bean) {
                    property.set(bean, (Object)PlexusLifecycleManager.this.getPlexusLogger(bean));
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> pi) {
        List<?>[] holder = pendingHolder.get();
        if (null == holder[0]) {
            List<?> beans;
            holder[0] = Collections.EMPTY_LIST;
            try {
                pi.provision();
            }
            finally {
                beans = holder[0];
                holder[0] = null;
            }
            int size = beans.size();
            for (int i = 0; i < size; ++i) {
                this.manageLifecycle(beans.get(i));
            }
        }
    }

    @Override
    public boolean manage(Object bean) {
        if (bean instanceof Disposable) {
            PlexusLifecycleManager.synchronizedAdd(this.disposableBeans, (Disposable)bean);
        }
        if (bean instanceof LogEnabled) {
            ((LogEnabled)bean).enableLogging(this.getPlexusLogger(bean));
        }
        if (bean instanceof Contextualizable || bean instanceof Initializable || bean instanceof Startable) {
            List<?>[] holder = pendingHolder.get();
            List<?> beans = holder[0];
            if (null == beans || beans.isEmpty()) {
                beans = new ArrayList();
                holder[0] = beans;
            }
            beans.add(bean);
        }
        return true;
    }

    @Override
    public boolean unmanage(Object bean) {
        if (PlexusLifecycleManager.synchronizedRemove(this.startableBeans, bean)) {
            this.stop((Startable)bean);
        }
        if (PlexusLifecycleManager.synchronizedRemove(this.disposableBeans, bean)) {
            this.dispose((Disposable)bean);
        }
        return true;
    }

    @Override
    public boolean unmanage() {
        Object bean;
        while ((bean = PlexusLifecycleManager.synchronizedRemoveLast(this.startableBeans)) != null) {
            this.stop((Startable)bean);
        }
        while ((bean = PlexusLifecycleManager.synchronizedRemoveLast(this.disposableBeans)) != null) {
            this.dispose((Disposable)bean);
        }
        pendingHolder.remove();
        return true;
    }

    public PlexusBeanManager manageChild() {
        return this;
    }

    Logger getPlexusLogger(Object bean) {
        String name = bean.getClass().getName();
        try {
            return ((LoggerManager)this.plexusLoggerManagerProvider.get()).getLoggerForComponent(name, null);
        }
        catch (RuntimeException e) {
            return this.consoleLogger;
        }
    }

    Object getSLF4JLogger(Object bean) {
        String name = bean.getClass().getName();
        try {
            return ((ILoggerFactory)this.slf4jLoggerFactoryProvider.get()).getLogger(name);
        }
        catch (RuntimeException e) {
            return LoggerFactory.getLogger((String)name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> boolean synchronizedAdd(List<T> list, T element) {
        List<T> list2 = list;
        synchronized (list2) {
            return list.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean synchronizedRemove(List<?> list, Object element) {
        List<?> list2 = list;
        synchronized (list2) {
            return list.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T synchronizedRemoveLast(List<T> list) {
        List<T> list2 = list;
        synchronized (list2) {
            int size = list.size();
            if (size > 0) {
                return list.remove(size - 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageLifecycle(Object bean) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            for (Class<?> clazz = bean.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                ClassLoader loader = clazz.getClassLoader();
                if (!(loader instanceof URLClassLoader)) continue;
                Thread.currentThread().setContextClassLoader(loader);
                break;
            }
            if (bean instanceof Contextualizable) {
                this.contextualize((Contextualizable)bean);
            }
            if (bean instanceof Initializable) {
                this.initialize((Initializable)bean);
            }
            if (bean instanceof Startable) {
                Startable startableBean = (Startable)bean;
                PlexusLifecycleManager.synchronizedAdd(this.startableBeans, startableBean);
                this.start(startableBean);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void contextualize(Contextualizable bean) {
        Logs.debug((String)"Contextualize: <>", (Object)bean, null);
        try {
            bean.contextualize((Context)this.plexusContextProvider.get());
        }
        catch (Throwable e) {
            Logs.catchThrowable((Throwable)e);
            try {
                this.getPlexusLogger(this).warn("Error contextualizing: " + Logs.identityToString((Object)bean), e);
            }
            finally {
                Logs.throwUnchecked((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Initializable bean) {
        Logs.debug((String)"Initialize: <>", (Object)bean, null);
        try {
            bean.initialize();
        }
        catch (Throwable e) {
            Logs.catchThrowable((Throwable)e);
            try {
                this.getPlexusLogger(this).warn("Error initializing: " + Logs.identityToString((Object)bean), e);
            }
            finally {
                Logs.throwUnchecked((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(Startable bean) {
        Logs.debug((String)"Start: <>", (Object)bean, null);
        try {
            bean.start();
        }
        catch (Throwable e) {
            Logs.catchThrowable((Throwable)e);
            try {
                this.getPlexusLogger(this).warn("Error starting: " + Logs.identityToString((Object)bean), e);
            }
            finally {
                Logs.throwUnchecked((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(Startable bean) {
        Logs.debug((String)"Stop: <>", (Object)bean, null);
        try {
            bean.stop();
        }
        catch (Throwable e) {
            Logs.catchThrowable((Throwable)e);
            try {
                this.getPlexusLogger(this).warn("Problem stopping: " + Logs.identityToString((Object)bean), e);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(Disposable bean) {
        Logs.debug((String)"Dispose: <>", (Object)bean, null);
        try {
            bean.dispose();
        }
        catch (Throwable e) {
            Logs.catchThrowable((Throwable)e);
            try {
                this.getPlexusLogger(this).warn("Problem disposing: " + Logs.identityToString((Object)bean), e);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }
}

