/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus.binders;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.spi.TypeListener;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.sisu.inject.BeanBinder;
import org.eclipse.sisu.inject.BeanListener;
import org.eclipse.sisu.plexus.binders.PlexusBeanBinder;
import org.eclipse.sisu.plexus.binders.PlexusBeanManager;
import org.eclipse.sisu.plexus.config.PlexusBeanModule;
import org.eclipse.sisu.plexus.config.PlexusBeanSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlexusBindingModule
implements Module {
    private final PlexusBeanManager manager;
    private final PlexusBeanModule[] modules;

    public PlexusBindingModule(PlexusBeanManager manager, PlexusBeanModule ... modules) {
        this.manager = manager;
        this.modules = (PlexusBeanModule[])modules.clone();
    }

    public PlexusBindingModule(PlexusBeanManager manager, Collection<PlexusBeanModule> modules) {
        this.manager = manager;
        this.modules = modules.toArray(new PlexusBeanModule[modules.size()]);
    }

    public void configure(Binder binder) {
        ArrayList<PlexusBeanSource> sources = new ArrayList<PlexusBeanSource>(this.modules.length);
        for (PlexusBeanModule module : this.modules) {
            PlexusBeanSource source = module.configure(binder);
            if (null == source) continue;
            sources.add(source);
        }
        PlexusBeanBinder plexusBinder = new PlexusBeanBinder(this.manager, sources);
        binder.bindListener(Matchers.any(), (TypeListener)new BeanListener((BeanBinder)plexusBinder));
        if (this.manager instanceof ProvisionListener) {
            binder.bindListener(Matchers.any(), new ProvisionListener[]{(ProvisionListener)this.manager});
        }
    }
}

