/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.mojos;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.sisu.reflect.ClassSpace;
import org.eclipse.sisu.reflect.URLClassSpace;
import org.eclipse.sisu.scanners.index.SisuIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexMojo
extends AbstractMojo {
    protected File outputDirectory;
    protected boolean includeDependencies;
    protected String excludeGroupIds;
    protected String includeGroupIds;
    protected String excludeArtifactIds;
    protected String includeArtifactIds;
    protected String excludeClassifiers;
    protected String includeClassifiers;
    protected String excludeTypes;
    protected String includeTypes;
    protected String excludeScope;
    protected String includeScope;
    protected boolean excludeTransitive;
    private MavenProject project;

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void execute() {
        new SisuIndex(this.outputDirectory).index((ClassSpace)new URLClassSpace(this.getProjectClassLoader(), this.getIndexPath()));
    }

    private ClassLoader getProjectClassLoader() {
        ArrayList<URL> classPath = new ArrayList<URL>();
        this.appendToClassPath(classPath, this.outputDirectory);
        this.appendToClassPath(classPath, new File(this.project.getBuild().getOutputDirectory()));
        for (Object artifact : this.project.getArtifacts()) {
            this.appendToClassPath(classPath, ((Artifact)artifact).getFile());
        }
        return URLClassLoader.newInstance(classPath.toArray(new URL[classPath.size()]));
    }

    private URL[] getIndexPath() {
        ArrayList<URL> indexPath = new ArrayList<URL>();
        this.appendToClassPath(indexPath, this.outputDirectory);
        if (this.includeDependencies) {
            FilterArtifacts filter = new FilterArtifacts();
            filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(this.project.getDependencyArtifacts(), this.excludeTransitive));
            filter.addFilter((ArtifactsFilter)new ScopeFilter(IndexMojo.cleanList(this.includeScope), IndexMojo.cleanList(this.excludeScope)));
            filter.addFilter((ArtifactsFilter)new TypeFilter(IndexMojo.cleanList(this.includeTypes), IndexMojo.cleanList(this.excludeTypes)));
            filter.addFilter((ArtifactsFilter)new ClassifierFilter(IndexMojo.cleanList(this.includeClassifiers), IndexMojo.cleanList(this.excludeClassifiers)));
            filter.addFilter((ArtifactsFilter)new GroupIdFilter(IndexMojo.cleanList(this.includeGroupIds), IndexMojo.cleanList(this.excludeGroupIds)));
            filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(IndexMojo.cleanList(this.includeArtifactIds), IndexMojo.cleanList(this.excludeArtifactIds)));
            try {
                for (Object artifact : filter.filter(this.project.getArtifacts())) {
                    this.appendToClassPath(indexPath, ((Artifact)artifact).getFile());
                }
            }
            catch (ArtifactFilterException e) {
                this.getLog().warn((CharSequence)e.getLocalizedMessage());
            }
        }
        return indexPath.toArray(new URL[indexPath.size()]);
    }

    private void appendToClassPath(List<URL> urls, File file) {
        if (null != file) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)e.getLocalizedMessage());
            }
        }
    }

    private static String cleanList(String list) {
        return StringUtils.isEmpty((String)list) ? "" : StringUtils.join((Object[])StringUtils.split((String)list), (String)",");
    }
}

