/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.afs.aws.dynamodb.types;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.serializer.concurrency.XThreads;
import org.eclipse.serializer.exceptions.IORuntimeException;
import org.eclipse.serializer.io.ByteBufferInputStream;
import org.eclipse.serializer.io.LimitedInputStream;
import org.eclipse.serializer.util.X;
import org.eclipse.store.afs.blobstore.types.BlobStoreConnector;
import org.eclipse.store.afs.blobstore.types.BlobStorePath;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.Delete;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.Put;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;

public interface DynamoDbConnector
extends BlobStoreConnector {
    public static DynamoDbConnector New(DynamoDbClient client) {
        return new Default((DynamoDbClient)X.notNull((Object)client), false);
    }

    public static DynamoDbConnector Caching(DynamoDbClient client) {
        return new Default((DynamoDbClient)X.notNull((Object)client), true);
    }

    public static class Default
    extends BlobStoreConnector.Abstract<Map<String, AttributeValue>>
    implements DynamoDbConnector {
        private static final String FIELD_KEY = "key";
        private static final String FIELD_SEQ = "seq";
        private static final String FIELD_SIZE = "size";
        private static final String FIELD_DATA = "data";
        private static final long MAX_BLOB_SIZE = 400000L;
        private static final long MAX_REQUEST_SIZE = 4000000L;
        private static final long MAX_REQUEST_ITEMS = 25L;
        private final DynamoDbClient client;
        private final Map<String, TableDescription> tables;

        Default(DynamoDbClient client, boolean useCache) {
            super(blob -> ((AttributeValue)blob.get(FIELD_KEY)).s(), blob -> Long.parseLong(((AttributeValue)blob.get(FIELD_SIZE)).n()), useCache);
            this.client = client;
            this.tables = new HashMap<String, TableDescription>();
        }

        private TableDescription table(BlobStorePath path) {
            return this.tables.computeIfAbsent(path.container(), this::createTable);
        }

        private TableDescription createTable(String name) {
            try {
                return this.client.describeTable(builder -> builder.tableName(name)).table();
            }
            catch (ResourceNotFoundException e) {
                CreateTableRequest request = (CreateTableRequest)CreateTableRequest.builder().tableName(name).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName(FIELD_KEY).keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName(FIELD_SEQ).keyType(KeyType.RANGE).build()}).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName(FIELD_KEY).attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName(FIELD_SEQ).attributeType(ScalarAttributeType.N).build()}).billingMode(BillingMode.PAY_PER_REQUEST).build();
                TableDescription description = this.client.createTable(request).tableDescription();
                while (description.tableStatus() != TableStatus.ACTIVE) {
                    XThreads.sleep((long)1000L);
                    description = this.client.describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(name).build()).table();
                }
                return description;
            }
        }

        private Stream<Map<String, AttributeValue>> blobs(BlobStorePath file, boolean withData) {
            HashMap<String, String> attributeNames = new HashMap<String, String>();
            attributeNames.put("#key", FIELD_KEY);
            attributeNames.put("#seq", FIELD_SEQ);
            attributeNames.put("#size", FIELD_SIZE);
            HashMap<String, AttributeValue> attributeValues = new HashMap<String, AttributeValue>();
            attributeValues.put(":key", (AttributeValue)AttributeValue.builder().s(file.fullQualifiedName()).build());
            QueryRequest.Builder builder = QueryRequest.builder().tableName(file.container()).keyConditionExpression("#key=:key").expressionAttributeNames(attributeNames).expressionAttributeValues(attributeValues);
            if (!withData) {
                builder.projectionExpression("#key,#seq,#size");
            }
            try {
                QueryResponse response = this.client.query((QueryRequest)builder.build());
                if (!response.hasItems()) {
                    return Stream.empty();
                }
                return response.items().stream().sorted(this.blobComparator());
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                return Stream.empty();
            }
        }

        private Map<String, AttributeValue> createKey(BlobStorePath file, Map<String, AttributeValue> blob) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put(FIELD_KEY, (AttributeValue)AttributeValue.builder().s(file.fullQualifiedName()).build());
            key.put(FIELD_SEQ, (AttributeValue)AttributeValue.builder().n(Long.toString(this.blobNumber(blob))).build());
            return key;
        }

        protected long blobNumber(Map<String, AttributeValue> blob) {
            return Long.parseLong(blob.get(FIELD_SEQ).n());
        }

        protected Stream<Map<String, AttributeValue>> blobs(BlobStorePath file) {
            return this.blobs(file, false);
        }

        protected Stream<String> childKeys(BlobStorePath directory) {
            HashMap<String, String> attributeNames = new HashMap<String, String>();
            attributeNames.put("#key", FIELD_KEY);
            HashMap<String, AttributeValue> expressionValues = new HashMap<String, AttributeValue>();
            expressionValues.put(":key", (AttributeValue)AttributeValue.builder().s(Default.toChildKeysPrefixWithContainer((BlobStorePath)directory)).build());
            ScanRequest request = (ScanRequest)ScanRequest.builder().tableName(directory.container()).filterExpression("begins_with(#key,:key)").projectionExpression("#key").expressionAttributeNames(attributeNames).expressionAttributeValues(expressionValues).build();
            ScanResponse response = this.client.scan(request);
            try {
                if (!response.hasItems()) {
                    return Stream.empty();
                }
                Pattern pattern = Pattern.compile(Default.childKeysRegexWithContainer((BlobStorePath)directory));
                return response.items().stream().map(item -> ((AttributeValue)item.get(FIELD_KEY)).s()).filter(key -> pattern.matcher((CharSequence)key).matches()).distinct();
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                return Stream.empty();
            }
        }

        protected String fileNameOfKey(String key) {
            return key.substring(key.lastIndexOf(47) + 1);
        }

        protected boolean internalFileExists(BlobStorePath file) {
            HashMap<String, String> attributeNames = new HashMap<String, String>();
            attributeNames.put("#key", FIELD_KEY);
            HashMap<String, AttributeValue> attributeValues = new HashMap<String, AttributeValue>();
            attributeValues.put(":key", (AttributeValue)AttributeValue.builder().s(file.fullQualifiedName()).build());
            QueryRequest request = (QueryRequest)QueryRequest.builder().tableName(file.container()).select(Select.COUNT).keyConditionExpression("#key=:key").expressionAttributeNames(attributeNames).expressionAttributeValues(attributeValues).build();
            try {
                QueryResponse response = this.client.query(request);
                return response.count() > 0;
            }
            catch (ResourceNotFoundException e) {
                return false;
            }
        }

        protected void internalReadBlobData(BlobStorePath file, Map<String, AttributeValue> blob, ByteBuffer targetBuffer, long offset, long length) {
            GetItemRequest request = (GetItemRequest)GetItemRequest.builder().tableName(file.container()).key(this.createKey(file, blob)).attributesToGet(new String[]{FIELD_DATA}).build();
            GetItemResponse response = this.client.getItem(request);
            Map item = response.item();
            targetBuffer.put(((AttributeValue)item.get(FIELD_DATA)).b().asByteArrayUnsafe(), X.checkArrayRange((long)offset), X.checkArrayRange((long)length));
        }

        protected boolean internalDeleteBlobs(BlobStorePath file, List<? extends Map<String, AttributeValue>> blobs) {
            BatchDelete batchDelete = new BatchDelete(this.client);
            for (Map<String, AttributeValue> map : blobs) {
                Delete delete = (Delete)Delete.builder().tableName(file.container()).key(this.createKey(file, map)).build();
                batchDelete.add(delete);
            }
            batchDelete.finish();
            return batchDelete.hasWritten();
        }

        protected long internalWriteData(BlobStorePath file, Iterable<? extends ByteBuffer> sourceBuffers) {
            long currentBatchSize;
            BatchPut batchPut = new BatchPut(this.client);
            String tableName = this.table(file).tableName();
            long nextBlobNumber = this.nextBlobNumber(file);
            long totalSize = this.totalSize(sourceBuffers);
            ByteBufferInputStream buffersInputStream = ByteBufferInputStream.New(sourceBuffers);
            for (long available = totalSize; available > 0L; available -= currentBatchSize) {
                currentBatchSize = Math.min(available, 400000L);
                try (LimitedInputStream limitedInputStream = LimitedInputStream.New((InputStream)new BufferedInputStream((InputStream)buffersInputStream), (long)currentBatchSize);){
                    int read;
                    byte[] batch = new byte[X.checkArrayRange((long)currentBatchSize)];
                    for (int remaining = batch.length; remaining > 0 && (read = limitedInputStream.read(batch, 0, Math.min(batch.length, remaining))) != -1; remaining -= read) {
                    }
                    HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
                    item.put(FIELD_KEY, (AttributeValue)AttributeValue.builder().s(file.fullQualifiedName()).build());
                    item.put(FIELD_SEQ, (AttributeValue)AttributeValue.builder().n(Long.toString(nextBlobNumber++)).build());
                    item.put(FIELD_SIZE, (AttributeValue)AttributeValue.builder().n(Long.toString(currentBatchSize)).build());
                    item.put(FIELD_DATA, (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArrayUnsafe((byte[])batch)).build());
                    Put put = (Put)Put.builder().tableName(tableName).item(item).build();
                    batchPut.add(put);
                    continue;
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
            batchPut.finish();
            return totalSize;
        }

        private static class BatchPut
        extends BatchWrite {
            BatchPut(DynamoDbClient client) {
                super(client);
            }

            void add(Put put) {
                int itemCount = this.addItem((TransactWriteItem)TransactWriteItem.builder().put(put).build());
                if ((long)itemCount >= 25L || (long)itemCount * 400000L >= 4000000L) {
                    this.write();
                }
            }
        }

        private static class BatchDelete
        extends BatchWrite {
            BatchDelete(DynamoDbClient client) {
                super(client);
            }

            void add(Delete delete) {
                int itemCount = this.addItem((TransactWriteItem)TransactWriteItem.builder().delete(delete).build());
                if ((long)itemCount >= 25L) {
                    this.write();
                }
            }
        }

        private static abstract class BatchWrite {
            final DynamoDbClient client;
            final List<TransactWriteItem> items;
            boolean written = false;

            BatchWrite(DynamoDbClient client) {
                this.client = client;
                this.items = new ArrayList<TransactWriteItem>();
            }

            int addItem(TransactWriteItem item) {
                this.items.add(item);
                return this.items.size();
            }

            void finish() {
                if (!this.items.isEmpty()) {
                    this.write();
                }
            }

            void write() {
                TransactWriteItemsRequest request = (TransactWriteItemsRequest)TransactWriteItemsRequest.builder().transactItems(this.items).build();
                this.client.transactWriteItems(request);
                this.items.clear();
                this.written = true;
            }

            boolean hasWritten() {
                return this.written;
            }
        }
    }
}

