/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.afs.aws.dynamodb.types;

import org.eclipse.serializer.afs.types.AFileSystem;
import org.eclipse.serializer.configuration.types.Configuration;
import org.eclipse.store.afs.aws.dynamodb.types.DynamoDbConnector;
import org.eclipse.store.afs.aws.types.AwsFileSystemCreator;
import org.eclipse.store.afs.blobstore.types.BlobStoreConnector;
import org.eclipse.store.afs.blobstore.types.BlobStoreFileSystem;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

public class DynamoDbFileSystemCreator
extends AwsFileSystemCreator {
    public AFileSystem create(Configuration configuration) {
        Configuration dynamoConfiguration = configuration.child("aws.dynamodb");
        if (dynamoConfiguration == null) {
            return null;
        }
        DynamoDbClientBuilder clientBuilder = DynamoDbClient.builder();
        this.populateBuilder((AwsClientBuilder)clientBuilder, dynamoConfiguration);
        DynamoDbClient client = (DynamoDbClient)clientBuilder.build();
        boolean cache = configuration.optBoolean("cache").orElse(true);
        DynamoDbConnector connector = cache ? DynamoDbConnector.Caching(client) : DynamoDbConnector.New(client);
        return BlobStoreFileSystem.New((BlobStoreConnector)connector);
    }
}

