/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.afs.aws.s3.types;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.serializer.exceptions.IORuntimeException;
import org.eclipse.serializer.io.ByteBufferInputStream;
import org.eclipse.serializer.util.X;
import org.eclipse.store.afs.aws.s3.types.S3PathValidator;
import org.eclipse.store.afs.blobstore.types.BlobStoreConnector;
import org.eclipse.store.afs.blobstore.types.BlobStorePath;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

public interface S3Connector
extends BlobStoreConnector {
    public static S3Connector New(S3Client s3) {
        return new Default((S3Client)X.notNull((Object)s3), false);
    }

    public static S3Connector Caching(S3Client s3) {
        return new Default((S3Client)X.notNull((Object)s3), true);
    }

    public static S3Connector NewDirectory(S3Client s3) {
        return new Directory((S3Client)X.notNull((Object)s3), false);
    }

    public static S3Connector CachingDirectory(S3Client s3) {
        return new Directory((S3Client)X.notNull((Object)s3), true);
    }

    public static class Directory
    extends Default {
        Directory(S3Client s3, boolean useCache) {
            super(s3, useCache);
        }

        @Override
        protected Stream<S3Object> blobs(BlobStorePath file) {
            ListObjectsV2Response response;
            String prefix = Directory.toChildKeysPrefix((BlobStorePath)file.parentPath());
            Pattern pattern = Pattern.compile(Directory.blobKeyRegex((String)Directory.toBlobKeyPrefix((BlobStorePath)file)));
            ArrayList blobs = new ArrayList();
            String continuationToken = null;
            do {
                ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(file.container()).prefix(prefix).continuationToken(continuationToken).build();
                response = this.s3.listObjectsV2(request);
                blobs.addAll(response.contents());
            } while ((continuationToken = response.isTruncated() != false ? response.nextContinuationToken() : null) != null);
            return blobs.stream().filter(obj -> pattern.matcher(obj.key()).matches()).sorted(this.blobComparator());
        }
    }

    public static class Default
    extends BlobStoreConnector.Abstract<S3Object>
    implements S3Connector {
        protected final S3Client s3;

        Default(S3Client s3, boolean useCache) {
            super(S3Object::key, S3Object::size, (BlobStorePath.Validator)S3PathValidator.New(), useCache);
            this.s3 = s3;
        }

        protected Stream<S3Object> blobs(BlobStorePath file) {
            ListObjectsV2Response response;
            String prefix = Default.toBlobKeyPrefix((BlobStorePath)file);
            Pattern pattern = Pattern.compile(Default.blobKeyRegex((String)prefix));
            ArrayList blobs = new ArrayList();
            String continuationToken = null;
            do {
                ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(file.container()).prefix(prefix).continuationToken(continuationToken).build();
                response = this.s3.listObjectsV2(request);
                blobs.addAll(response.contents());
            } while ((continuationToken = response.isTruncated() != false ? response.nextContinuationToken() : null) != null);
            return blobs.stream().filter(obj -> pattern.matcher(obj.key()).matches()).sorted(this.blobComparator());
        }

        protected Stream<String> childKeys(BlobStorePath directory) {
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(directory.container()).prefix(Default.toChildKeysPrefix((BlobStorePath)directory)).delimiter("/").build();
            return this.s3.listObjectsV2(request).contents().stream().map(S3Object::key);
        }

        protected void internalReadBlobData(BlobStorePath file, S3Object blob, ByteBuffer targetBuffer, long offset, long length) {
            GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(file.container()).key(blob.key()).range("bytes=" + offset + "-" + (offset + length - 1L)).build();
            ResponseBytes response = this.s3.getObjectAsBytes(request);
            targetBuffer.put(response.asByteBuffer());
        }

        protected boolean internalDirectoryExists(BlobStorePath directory) {
            try {
                String containerKey = Default.toContainerKey((BlobStorePath)directory);
                if (containerKey.isBlank() || "/".equals(containerKey)) {
                    return true;
                }
                PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(directory.container()).key(containerKey).build();
                this.s3.putObject(request, RequestBody.empty());
                return true;
            }
            catch (NoSuchKeyException e) {
                return false;
            }
        }

        protected boolean internalFileExists(BlobStorePath file) {
            try {
                return super.internalFileExists(file);
            }
            catch (NoSuchBucketException e) {
                return false;
            }
        }

        protected boolean internalCreateDirectory(BlobStorePath directory) {
            String containerKey = Default.toContainerKey((BlobStorePath)directory);
            if (containerKey.isBlank() || "/".equals(containerKey)) {
                return true;
            }
            PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(directory.container()).key(containerKey).build();
            RequestBody body = RequestBody.empty();
            this.s3.putObject(request, body);
            return true;
        }

        protected boolean internalDeleteBlobs(BlobStorePath file, List<? extends S3Object> blobs) {
            int limit = 1000;
            if (blobs.size() <= 1000) {
                return this.internalDeleteBlobs0(file, blobs);
            }
            boolean success = true;
            ArrayList<? extends S3Object> toDelete = new ArrayList<S3Object>(blobs);
            while (!toDelete.isEmpty()) {
                List subList = toDelete.subList(0, Math.min(1000, toDelete.size()));
                toDelete.removeAll(subList);
                if (this.internalDeleteBlobs0(file, subList)) continue;
                success = false;
            }
            return success;
        }

        protected boolean internalDeleteBlobs0(BlobStorePath file, List<? extends S3Object> blobs) {
            List objects = blobs.stream().map(obj -> (ObjectIdentifier)ObjectIdentifier.builder().key(obj.key()).build()).collect(Collectors.toList());
            DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(file.container()).delete((Delete)Delete.builder().objects(objects).build()).build();
            DeleteObjectsResponse response = this.s3.deleteObjects(request);
            return response.deleted().size() == blobs.size();
        }

        protected long internalWriteData(BlobStorePath file, Iterable<? extends ByteBuffer> sourceBuffers) {
            long nextBlobNumber = this.nextBlobNumber(file);
            long totalSize = this.totalSize(sourceBuffers);
            PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(file.container()).key(Default.toBlobKey((BlobStorePath)file, (long)nextBlobNumber)).build();
            try (BufferedInputStream inputStream = new BufferedInputStream((InputStream)ByteBufferInputStream.New(sourceBuffers));){
                RequestBody body = RequestBody.fromContentProvider(() -> inputStream, (long)totalSize, (String)"application/octet-stream");
                this.s3.putObject(request, body);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            return totalSize;
        }
    }
}

