/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.afs.aws.s3.types;

import org.eclipse.serializer.afs.types.AFileSystem;
import org.eclipse.serializer.configuration.types.Configuration;
import org.eclipse.store.afs.aws.s3.types.S3Connector;
import org.eclipse.store.afs.aws.types.AwsFileSystemCreator;
import org.eclipse.store.afs.blobstore.types.BlobStoreConnector;
import org.eclipse.store.afs.blobstore.types.BlobStoreFileSystem;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class S3FileSystemCreator
extends AwsFileSystemCreator {
    public S3FileSystemCreator() {
        super("aws.s3");
    }

    public AFileSystem create(Configuration configuration) {
        S3ClientBuilder clientBuilder = S3Client.builder();
        this.populateBuilder((AwsClientBuilder)clientBuilder, configuration);
        S3Client client = (S3Client)clientBuilder.build();
        boolean cache = configuration.optBoolean("cache").orElse(true);
        boolean directory = configuration.optBoolean("directory-bucket").orElse(false);
        S3Connector connector = directory ? (cache ? S3Connector.CachingDirectory(client) : S3Connector.NewDirectory(client)) : (cache ? S3Connector.Caching(client) : S3Connector.New(client));
        return BlobStoreFileSystem.New((BlobStoreConnector)connector);
    }
}

