/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.afs.aws.types;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.serializer.afs.types.AFileSystem;
import org.eclipse.serializer.configuration.exceptions.ConfigurationException;
import org.eclipse.serializer.configuration.types.Configuration;
import org.eclipse.serializer.configuration.types.ConfigurationBasedCreator;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;

public abstract class AwsFileSystemCreator
extends ConfigurationBasedCreator.Abstract<AFileSystem> {
    protected AwsFileSystemCreator() {
        super(AFileSystem.class);
    }

    protected void populateBuilder(AwsClientBuilder<?, ?> clientBuilder, Configuration configuration) {
        configuration.opt("endpoint-override").ifPresent(endpointOverride -> {
            try {
                clientBuilder.endpointOverride(new URI((String)endpointOverride));
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException(configuration, (Throwable)e);
            }
        });
        configuration.opt("region").ifPresent(region -> clientBuilder.region(Region.of((String)region)));
        configuration.opt("credentials.type").ifPresent(credentialsType -> {
            switch (credentialsType) {
                case "environment-variables": {
                    clientBuilder.credentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create());
                    break;
                }
                case "system-properties": {
                    clientBuilder.credentialsProvider((AwsCredentialsProvider)SystemPropertyCredentialsProvider.create());
                    break;
                }
                case "static": {
                    clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)configuration.get("credentials.access-key-id"), (String)configuration.get("credentials.secret-access-key"))));
                    break;
                }
                case "default": {
                    clientBuilder.credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create());
                    break;
                }
            }
        });
    }
}

