/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.afs.nio.types;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.eclipse.serializer.io.XIO;
import org.eclipse.serializer.util.X;

@FunctionalInterface
public interface NioPathResolver {
    public Path resolvePath(String ... var1);

    public static NioPathResolver New() {
        return new Default(FileSystems.getDefault());
    }

    public static NioPathResolver New(FileSystem fileSystem) {
        return new Default((FileSystem)X.notNull((Object)fileSystem));
    }

    public static class Default
    implements NioPathResolver {
        private final FileSystem fileSystem;

        Default(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        @Override
        public Path resolvePath(String ... pathElements) {
            return XIO.Path((FileSystem)this.fileSystem, (String[])pathElements);
        }
    }
}

