/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.integrations.spring.boot.types.concurrent;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.eclipse.serializer.util.logging.Logging;
import org.eclipse.store.integrations.spring.boot.types.concurrent.Mutex;
import org.slf4j.Logger;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Aspect
@Component
@Conditional(value={AspectJCondition.class})
public class LockAspect {
    private final Logger logger = Logging.getLogger(LockAspect.class);
    private final ReentrantReadWriteLock globalLock = new ReentrantReadWriteLock();
    private final ConcurrentHashMap<String, ReentrantReadWriteLock> locks = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(Read)")
    public Object readOperation(ProceedingJoinPoint joinPoint) throws Throwable {
        Object proceed;
        ReentrantReadWriteLock lock = this.findLock(joinPoint);
        lock.readLock().lock();
        this.logger.trace("lock readLock");
        try {
            proceed = joinPoint.proceed();
        }
        finally {
            lock.readLock().unlock();
            this.logger.trace("unlock readLock");
        }
        return proceed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(Write)")
    public Object writeOperation(ProceedingJoinPoint joinPoint) throws Throwable {
        Object proceed;
        ReentrantReadWriteLock lock = this.findLock(joinPoint);
        lock.writeLock().lock();
        this.logger.trace("write lock");
        try {
            proceed = joinPoint.proceed();
        }
        finally {
            lock.writeLock().unlock();
            this.logger.trace("write unlock");
        }
        return proceed;
    }

    private ReentrantReadWriteLock findLock(ProceedingJoinPoint joinPoint) {
        ReentrantReadWriteLock finalLock;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Mutex annotation = method.getAnnotation(Mutex.class);
        if (annotation != null) {
            String lockName = annotation.value();
            this.logger.trace("Found method lock annotation for lock: {}", (Object)lockName);
            finalLock = this.getOrCreateLock(lockName);
        } else {
            Class<?> declaringClass = method.getDeclaringClass();
            Mutex classAnnotation = declaringClass.getAnnotation(Mutex.class);
            if (classAnnotation != null) {
                String classLockName = classAnnotation.value();
                this.logger.trace("Found class lock annotation for lock: {}", (Object)classLockName);
                finalLock = this.getOrCreateLock(classLockName);
            } else {
                this.logger.trace("Found no @Lockable annotation, use global lock");
                finalLock = this.globalLock;
            }
        }
        return finalLock;
    }

    private ReentrantReadWriteLock getOrCreateLock(String lockName) {
        return this.locks.computeIfAbsent(lockName, k -> {
            this.logger.trace("Lock for name: {} not found, creating a new one", (Object)lockName);
            return new ReentrantReadWriteLock();
        });
    }

    static class AspectJCondition
    implements Condition {
        AspectJCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return ClassUtils.isPresent((String)"org.aspectj.lang.ProceedingJoinPoint", (ClassLoader)context.getClassLoader());
        }
    }
}

