/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.integrations.spring.boot.types;

import org.eclipse.store.integrations.spring.boot.types.EclipseStoreSpringBoot;
import org.eclipse.store.integrations.spring.boot.types.configuration.ConfigurationPair;
import org.eclipse.store.integrations.spring.boot.types.configuration.EclipseStoreProperties;
import org.eclipse.store.integrations.spring.boot.types.factories.EmbeddedStorageFoundationFactory;
import org.eclipse.store.integrations.spring.boot.types.factories.EmbeddedStorageManagerFactory;
import org.eclipse.store.integrations.spring.boot.types.suppliers.EmbeddedStorageFoundationSupplier;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageFoundation;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={EclipseStoreSpringBoot.class})
@ComponentScan(value={"org.eclipse.store.integrations.spring.boot.types.concurrent"})
public class DefaultEclipseStoreConfiguration {
    public static final String DEFAULT_QUALIFIER = "defaultEclipseStore";

    @Bean
    @Qualifier(value="defaultEclipseStore")
    @ConfigurationProperties(prefix="org.eclipse.store")
    public EclipseStoreProperties defaultEclipseStoreProperties() {
        return new EclipseStoreProperties();
    }

    @Bean
    @Qualifier(value="defaultEclipseStore")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.eclipse.store", name={"auto-create-default-foundation"}, havingValue="true", matchIfMissing=true)
    public EmbeddedStorageFoundationSupplier<EmbeddedStorageFoundation<?>> defaultStorageFoundationSupplier(@Qualifier(value="defaultEclipseStore") EclipseStoreProperties eclipseStoreProperties, EmbeddedStorageFoundationFactory foundationFactory) {
        return () -> foundationFactory.createStorageFoundation(eclipseStoreProperties, new ConfigurationPair[0]);
    }

    @Bean
    @Qualifier(value="defaultEclipseStore")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.eclipse.store", name={"auto-create-default-storage"}, havingValue="true", matchIfMissing=true)
    public EmbeddedStorageManager defaultStorageManager(EmbeddedStorageManagerFactory embeddedStorageManagerFactory, @Qualifier(value="defaultEclipseStore") EclipseStoreProperties eclipseStoreProperties, @Qualifier(value="defaultEclipseStore") EmbeddedStorageFoundationSupplier<EmbeddedStorageFoundation<?>> embeddedStorageFoundationSupplier) {
        return embeddedStorageManagerFactory.createStorage((EmbeddedStorageFoundation)embeddedStorageFoundationSupplier.get(), eclipseStoreProperties.isAutoStart());
    }
}

