/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.integrations.spring.boot.types.converter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.store.integrations.spring.boot.types.configuration.EclipseStoreProperties;
import org.eclipse.store.integrations.spring.boot.types.configuration.StorageFilesystem;
import org.eclipse.store.integrations.spring.boot.types.configuration.aws.AbstractAwsProperties;
import org.eclipse.store.integrations.spring.boot.types.configuration.aws.Aws;
import org.eclipse.store.integrations.spring.boot.types.configuration.aws.S3;
import org.eclipse.store.integrations.spring.boot.types.configuration.azure.Azure;
import org.eclipse.store.integrations.spring.boot.types.configuration.oraclecloud.Oraclecloud;
import org.eclipse.store.integrations.spring.boot.types.configuration.sql.AbstractSqlConfiguration;
import org.eclipse.store.integrations.spring.boot.types.configuration.sql.Sql;
import org.eclipse.store.integrations.spring.boot.types.converter.ConfigKeys;

public class EclipseStoreConfigConverter {
    protected static final String STORAGE_DIRECTORY = "storage-directory";
    protected static final String STORAGE_FILESYSTEM = "storage-filesystem";
    protected static final String DELETION_DIRECTORY = "deletion-directory";
    protected static final String TRUNCATION_DIRECTORY = "truncation-directory";
    protected static final String BACKUP_DIRECTORY = "backup-directory";
    protected static final String BACKUP_FILESYSTEM = "backup-filesystem";
    protected static final String CHANNEL_COUNT = "channel-count";
    protected static final String CHANNEL_DIRECTORY_PREFIX = "channel-directory-prefix";
    protected static final String DATA_FILE_PREFIX = "data-file-prefix";
    protected static final String DATA_FILE_SUFFIX = "data-file-suffix";
    protected static final String TRANSACTION_FILE_PREFIX = "transaction-file-prefix";
    protected static final String TRANSACTION_FILE_SUFFIX = "transaction-file-suffix";
    protected static final String TRANSACTION_FILE_MAXIMUM_SIZE = "transaction-file-maximum-size";
    protected static final String TYPE_DICTIONARY_FILE_NAME = "type-dictionary-file-name";
    protected static final String RESCUED_FILE_SUFFIX = "rescued-file-suffix";
    protected static final String LOCK_FILE_NAME = "lock-file-name";
    protected static final String HOUSEKEEPING_INTERVAL = "housekeeping-interval";
    protected static final String HOUSEKEEPING_TIME_BUDGET = "housekeeping-time-budget";
    protected static final String HOUSEKEEPING_ADAPTIVE = "housekeeping-adaptive";
    protected static final String HOUSEKEEPING_INCREASE_THRESHOLD = "housekeeping-increase-threshold";
    protected static final String HOUSEKEEPING_INCREASE_AMOUNT = "housekeeping-increase-amount";
    protected static final String HOUSEKEEPING_MAXIMUM_TIME_BUDGET = "housekeeping-maximum-time-budget";
    protected static final String ENTITY_CACHE_THRESHOLD = "entity-cache-threshold";
    protected static final String ENTITY_CACHE_TIMEOUT = "entity-cache-timeout";
    protected static final String DATA_FILE_MINIMUM_SIZE = "data-file-minimum-size";
    protected static final String DATA_FILE_MAXIMUM_SIZE = "data-file-maximum-size";
    protected static final String DATA_FILE_MINIMUM_USE_RATIO = "data-file-minimum-use-ratio";
    protected static final String DATA_FILE_CLEANUP_HEAD_FILE = "data-file-cleanup-head-file";

    public Map<String, String> convertConfigurationToMap(EclipseStoreProperties properties) {
        HashMap<String, String> configValues = new HashMap<String, String>();
        configValues.put(STORAGE_DIRECTORY, properties.getStorageDirectory());
        if (properties.getStorageFilesystem() != null) {
            configValues.putAll(this.prepareFileSystem(properties.getStorageFilesystem(), STORAGE_FILESYSTEM));
        }
        configValues.put(DELETION_DIRECTORY, properties.getDeletionDirectory());
        configValues.put(TRUNCATION_DIRECTORY, properties.getTruncationDirectory());
        configValues.put(BACKUP_DIRECTORY, properties.getBackupDirectory());
        if (properties.getBackupFilesystem() != null) {
            configValues.putAll(this.prepareFileSystem(properties.getBackupFilesystem(), BACKUP_FILESYSTEM));
        }
        configValues.put(CHANNEL_COUNT, properties.getChannelCount());
        configValues.put(CHANNEL_DIRECTORY_PREFIX, properties.getChannelDirectoryPrefix());
        configValues.put(DATA_FILE_PREFIX, properties.getDataFilePrefix());
        configValues.put(DATA_FILE_SUFFIX, properties.getDataFileSuffix());
        configValues.put(TRANSACTION_FILE_PREFIX, properties.getTransactionFilePrefix());
        configValues.put(TRANSACTION_FILE_SUFFIX, properties.getTransactionFileSuffix());
        configValues.put(TRANSACTION_FILE_MAXIMUM_SIZE, properties.getTransactionFileMaximumSize());
        configValues.put(TYPE_DICTIONARY_FILE_NAME, properties.getTypeDictionaryFileName());
        configValues.put(RESCUED_FILE_SUFFIX, properties.getRescuedFileSuffix());
        configValues.put(LOCK_FILE_NAME, properties.getLockFileName());
        configValues.put(HOUSEKEEPING_INTERVAL, properties.getHousekeepingInterval());
        configValues.put(HOUSEKEEPING_TIME_BUDGET, properties.getHousekeepingTimeBudget());
        configValues.put(HOUSEKEEPING_ADAPTIVE, properties.isHousekeepingAdaptive() ? "true" : null);
        configValues.put(HOUSEKEEPING_INCREASE_THRESHOLD, properties.getHousekeepingIncreaseThreshold());
        configValues.put(HOUSEKEEPING_INCREASE_AMOUNT, properties.getHousekeepingIncreaseAmount());
        configValues.put(HOUSEKEEPING_MAXIMUM_TIME_BUDGET, properties.getHousekeepingMaximumTimeBudget());
        configValues.put(ENTITY_CACHE_THRESHOLD, properties.getEntityCacheThreshold());
        configValues.put(ENTITY_CACHE_TIMEOUT, properties.getEntityCacheTimeout());
        configValues.put(DATA_FILE_MINIMUM_SIZE, properties.getDataFileMinimumSize());
        configValues.put(DATA_FILE_MAXIMUM_SIZE, properties.getDataFileMaximumSize());
        configValues.put(DATA_FILE_MINIMUM_USE_RATIO, properties.getDataFileMinimumUseRatio());
        configValues.put(DATA_FILE_CLEANUP_HEAD_FILE, properties.getDataFileCleanupHeadFile());
        configValues.values().removeIf(Objects::isNull);
        return configValues;
    }

    private Map<String, String> prepareFileSystem(StorageFilesystem properties, String key) {
        HashMap<String, String> values = new HashMap<String, String>();
        String target = properties.getTarget();
        if (target != null) {
            values.put(this.composeKey(key, ConfigKeys.TARGET.value()), target);
        }
        if (properties.getSql() != null) {
            values.putAll(this.prepareSql(properties.getSql(), this.composeKey(key, ConfigKeys.SQL.value())));
        }
        if (properties.getAws() != null) {
            values.putAll(this.prepareAws(properties.getAws(), this.composeKey(key, ConfigKeys.AWS.value())));
        }
        if (properties.getAzure() != null) {
            values.putAll(this.prepareAzure(properties.getAzure(), this.composeKey(key, ConfigKeys.AZURE.value())));
        }
        if (properties.getOraclecloud() != null) {
            values.putAll(this.prepareOracleCloud(properties.getOraclecloud(), this.composeKey(key, ConfigKeys.ORACLECLOUD.value())));
        }
        if (properties.getRedis() != null) {
            values.put(ConfigKeys.REDIS_URI.value(), properties.getRedis().getUri());
        }
        return values;
    }

    private Map<String, String> prepareOracleCloud(Oraclecloud oraclecloud, String key) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(this.composeKey(key, ConfigKeys.ORACLECLOUD_CONFIG_FILE_PATH.value()), oraclecloud.getObjectStorage().getConfigFile().getPath());
        values.put(this.composeKey(key, ConfigKeys.ORACLECLOUD_CONFIG_FILE_PROFILE.value()), oraclecloud.getObjectStorage().getConfigFile().getProfile());
        values.put(this.composeKey(key, ConfigKeys.ORACLECLOUD_CONFIG_FILE_CHARSET.value()), oraclecloud.getObjectStorage().getConfigFile().getCharset());
        values.put(this.composeKey(key, ConfigKeys.ORACLECLOUD_CLIENT_CONNECTION_TIMEOUT_MILLIS.value()), oraclecloud.getObjectStorage().getClient().getConnectionTimeoutMillis());
        values.put(this.composeKey(key, ConfigKeys.ORACLECLOUD_CLIENT_READ_TIMEOUT_MILLIS.value()), oraclecloud.getObjectStorage().getClient().getReadTimeoutMillis());
        values.put(this.composeKey(key, ConfigKeys.ORACLECLOUD_CLIENT_MAX_ASYNC_THREADS.value()), oraclecloud.getObjectStorage().getClient().getMaxAsyncThreads());
        values.put(this.composeKey(key, ConfigKeys.ORACLECLOUD_REGION.value()), oraclecloud.getObjectStorage().getRegion());
        values.put(this.composeKey(key, ConfigKeys.ORACLECLOUD_ENDPOINT.value()), oraclecloud.getObjectStorage().getEndpoint());
        return values;
    }

    private Map<String, String> prepareAzure(Azure azure, String key) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(this.composeKey(key, ConfigKeys.AZURE_STORAGE_CONNECTION_STRING.value()), azure.getStorage().getConnectionString());
        values.put(this.composeKey(key, ConfigKeys.AZURE_STORAGE_ENCRYPTION_SCOPE.value()), azure.getStorage().getEncryptionScope());
        values.put(this.composeKey(key, ConfigKeys.AZURE_STORAGE_CREDENTIALS_TYPE.value()), azure.getStorage().getCredentials().getType());
        values.put(this.composeKey(key, ConfigKeys.AZURE_STORAGE_CREDENTIALS_USERNAME.value()), azure.getStorage().getCredentials().getUsername());
        values.put(this.composeKey(key, ConfigKeys.AZURE_STORAGE_CREDENTIALS_PASSWORD.value()), azure.getStorage().getCredentials().getPassword());
        values.put(this.composeKey(key, ConfigKeys.AZURE_STORAGE_CREDENTIALS_ACCOUNT_NAME.value()), azure.getStorage().getCredentials().getAccountMame());
        values.put(this.composeKey(key, ConfigKeys.AZURE_STORAGE_CREDENTIALS_ACCOUNT_KEY.value()), azure.getStorage().getCredentials().getAccountKey());
        return values;
    }

    private Map<String, String> prepareAws(Aws aws, String key) {
        S3 s3;
        HashMap<String, String> values = new HashMap<String, String>();
        if (aws.getDynamodb() != null) {
            values.putAll(this.prepareAwsProperties(aws.getDynamodb(), this.composeKey(key, ConfigKeys.DYNAMODB.value())));
        }
        if ((s3 = aws.getS3()) != null) {
            String s3Key = this.composeKey(key, ConfigKeys.S3.value());
            values.putAll(this.prepareAwsProperties(s3, s3Key));
            values.put(this.composeKey(s3Key, ConfigKeys.AWS_DIRECTORY_BUCKET.value()), Boolean.toString(s3.isDirectoryBucket()));
        }
        return values;
    }

    private Map<String, String> prepareAwsProperties(AbstractAwsProperties awsProperties, String key) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(this.composeKey(key, ConfigKeys.CACHE.value()), Boolean.toString(awsProperties.isCache()));
        values.put(this.composeKey(key, ConfigKeys.AWS_ENDPOINT_OVERRIDE.value()), awsProperties.getEndpointOverride());
        values.put(this.composeKey(key, ConfigKeys.AWS_REGION.value()), awsProperties.getRegion());
        values.put(this.composeKey(key, ConfigKeys.AWS_CREDENTIALS_TYPE.value()), awsProperties.getCredentials().getType());
        values.put(this.composeKey(key, ConfigKeys.AWS_CREDENTIALS_ACCESS_KEY_ID.value()), awsProperties.getCredentials().getAccessKeyId());
        values.put(this.composeKey(key, ConfigKeys.AWS_CREDENTIALS_SECRET_ACCESS_KEY.value()), awsProperties.getCredentials().getSecretAccessKey());
        return values;
    }

    private Map<String, String> prepareSql(Sql sql, String key) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (sql.getMariadb() != null) {
            values.putAll(this.prepareSqlBasic(sql.getMariadb(), this.composeKey(key, ConfigKeys.MARIADB.value())));
        }
        if (sql.getOracle() != null) {
            values.putAll(this.prepareSqlBasic(sql.getOracle(), this.composeKey(key, ConfigKeys.ORACLE.value())));
        }
        if (sql.getPostgres() != null) {
            values.putAll(this.prepareSqlBasic(sql.getPostgres(), this.composeKey(key, ConfigKeys.POSTGRES.value())));
        }
        if (sql.getSqlite() != null) {
            values.putAll(this.prepareSqlBasic(sql.getSqlite(), this.composeKey(key, ConfigKeys.SQLITE.value())));
        }
        return values;
    }

    private Map<String, String> prepareSqlBasic(AbstractSqlConfiguration properties, String key) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(this.composeKey(key, ConfigKeys.SQL_DATA_SOURCE_PROVIDER.value()), properties.getDataSourceProvider());
        values.put(this.composeKey(key, ConfigKeys.SQL_CATALOG.value()), properties.getCatalog());
        values.put(this.composeKey(key, ConfigKeys.SQL_SCHEMA.value()), properties.getSchema());
        values.put(this.composeKey(key, ConfigKeys.SQL_URL.value()), properties.getUrl());
        values.put(this.composeKey(key, ConfigKeys.SQL_USER.value()), properties.getUser());
        values.put(this.composeKey(key, ConfigKeys.SQL_PASSWORD.value()), properties.getPassword());
        return values;
    }

    protected String composeKey(String prefix, String suffix) {
        return prefix + "." + suffix;
    }
}

