/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.integrations.spring.boot.types.factories;

import java.util.Map;
import org.eclipse.serializer.persistence.binary.jdk17.types.BinaryHandlersJDK17;
import org.eclipse.serializer.persistence.binary.jdk8.types.BinaryHandlersJDK8;
import org.eclipse.serializer.reflect.ClassLoaderProvider;
import org.eclipse.serializer.util.logging.Logging;
import org.eclipse.store.integrations.spring.boot.types.configuration.ConfigurationPair;
import org.eclipse.store.integrations.spring.boot.types.configuration.EclipseStoreProperties;
import org.eclipse.store.integrations.spring.boot.types.converter.EclipseStoreConfigConverter;
import org.eclipse.store.integrations.spring.boot.types.initializers.StorageContextInitializer;
import org.eclipse.store.storage.embedded.configuration.types.EmbeddedStorageConfigurationBuilder;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageFoundation;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EmbeddedStorageFoundationFactory
implements ApplicationContextAware {
    private final EclipseStoreConfigConverter converter;
    private final ClassLoaderProvider classLoaderProvider;
    private ApplicationContext applicationContext;
    private final Logger logger = Logging.getLogger(EmbeddedStorageFoundationFactory.class);

    public EmbeddedStorageFoundationFactory(EclipseStoreConfigConverter converter, ClassLoaderProvider classLoaderProvider) {
        this.converter = converter;
        this.classLoaderProvider = classLoaderProvider;
    }

    public EmbeddedStorageFoundation<?> createStorageFoundation(EclipseStoreProperties eclipseStoreProperties, ConfigurationPair ... additionalConfiguration) {
        try {
            StorageContextInitializer storageContextInitializer = (StorageContextInitializer)this.applicationContext.getBean(StorageContextInitializer.class);
            storageContextInitializer.initialize();
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.debug("No custom storage initializer found.");
        }
        EmbeddedStorageConfigurationBuilder builder = EmbeddedStorageConfigurationBuilder.New();
        Map<String, String> valueMap = this.converter.convertConfigurationToMap(eclipseStoreProperties);
        for (ConfigurationPair pair : additionalConfiguration) {
            valueMap.put(pair.key(), pair.value());
        }
        this.logger.debug("EclipseStore configuration items: ");
        valueMap.forEach((key, value) -> {
            if (value != null) {
                String logValue = key.contains("password") ? "xxxxxx" : value;
                this.logger.debug(key + " : " + logValue);
                builder.set(key, value);
            }
        });
        EmbeddedStorageFoundation storageFoundation = builder.createEmbeddedStorageFoundation();
        storageFoundation.getConnectionFoundation().setClassLoaderProvider(this.classLoaderProvider);
        Object root = this.createNewRootInstance(eclipseStoreProperties);
        if (root != null) {
            this.logger.debug("Root object: " + root.getClass().getName());
            storageFoundation.setRoot(root);
        }
        if (eclipseStoreProperties.isRegisterJdk8Handlers()) {
            this.logger.debug("Register JDK8 handlers. ");
            storageFoundation.onConnectionFoundation(BinaryHandlersJDK8::registerJDK8TypeHandlers);
        }
        if (eclipseStoreProperties.isRegisterJdk17Handlers()) {
            this.logger.debug("Register JDK17 handlers. ");
            storageFoundation.onConnectionFoundation(BinaryHandlersJDK17::registerJDK17TypeHandlers);
        }
        return storageFoundation;
    }

    protected Object createNewRootInstance(EclipseStoreProperties properties) {
        Class<?> rootClass = properties.getRoot();
        if (rootClass == null) {
            return null;
        }
        try {
            return rootClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate storage root: " + String.valueOf(rootClass), e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

