/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.eclipse.sw360.clients.adapter.AttachmentUploadRequest;
import org.eclipse.sw360.clients.adapter.AttachmentUploadResult;
import org.eclipse.sw360.clients.rest.SW360AttachmentAwareClient;
import org.eclipse.sw360.clients.rest.resource.SW360HalResource;
import org.eclipse.sw360.clients.rest.resource.attachments.SW360SparseAttachment;
import org.eclipse.sw360.clients.utils.FutureUtils;
import org.eclipse.sw360.clients.utils.SW360ClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SW360AttachmentUtils {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final String ALG_SHA1 = "SHA-1";
    private static final Logger LOGGER = LoggerFactory.getLogger(SW360AttachmentUtils.class);

    private SW360AttachmentUtils() {
    }

    public static <T extends SW360HalResource<?, ?>> CompletableFuture<AttachmentUploadResult<T>> uploadAttachments(SW360AttachmentAwareClient<T> client, AttachmentUploadRequest<T> uploadRequest, Function<? super T, Set<SW360SparseAttachment>> getAttachmentsFunc) {
        CompletionStage<AttachmentUploadResult<T>> futResult = CompletableFuture.completedFuture(new AttachmentUploadResult<T>(uploadRequest.getTarget()));
        for (AttachmentUploadRequest.Item item : uploadRequest.getItems()) {
            futResult = futResult.thenCompose(result -> {
                if (SW360AttachmentUtils.attachmentIsPotentialDuplicate(item.getPath(), (Set)getAttachmentsFunc.apply((Object)result.getTarget()))) {
                    return CompletableFuture.completedFuture(result.addFailedUpload(item, new SW360ClientException("Duplicate attachment file name: " + String.valueOf(item.getPath().getFileName()))));
                }
                return client.uploadAndAttachAttachment(result.getTarget(), item.getPath(), item.getAttachmentType()).handle((updatedEntity, ex) -> updatedEntity != null ? result.addSuccessfulUpload(updatedEntity, item) : result.addFailedUpload(item, (Throwable)ex));
            });
        }
        return futResult;
    }

    public static <T extends SW360HalResource<?, ?>> CompletableFuture<Optional<Path>> downloadAttachment(SW360AttachmentAwareClient<? extends T> client, T entity, SW360SparseAttachment attachment, Path downloadPath) {
        return Optional.ofNullable(entity.getSelfLink()).map(self -> {
            AttachmentDownloadProcessor downloadProcessor = SW360AttachmentUtils.defaultAttachmentDownloadProcessor(attachment, downloadPath);
            return FutureUtils.optionalFuture(client.processAttachment(self.getHref(), attachment.getId(), downloadProcessor));
        }).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    public static AttachmentDownloadProcessor defaultAttachmentDownloadProcessor(SW360SparseAttachment attachment, Path downloadPath) {
        return SW360AttachmentUtils.defaultAttachmentDownloadProcessor(attachment.getFilename(), downloadPath);
    }

    public static AttachmentDownloadProcessor defaultAttachmentDownloadProcessor(String fileName, Path downloadPath) {
        return new AttachmentDownloadProcessorCreateDownloadFolder(downloadPath, fileName, StandardCopyOption.REPLACE_EXISTING);
    }

    public static String calculateHash(Path file, MessageDigest digest) {
        try (DigestInputStream din = new DigestInputStream(Files.newInputStream(file, new OpenOption[0]), digest);){
            IOUtils.copy((InputStream)din, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        }
        catch (IOException e) {
            throw new SW360ClientException("Could not calculate hash for file " + String.valueOf(file), e);
        }
        return SW360AttachmentUtils.toHexString(digest.digest());
    }

    public static String calculateSha1Hash(Path file) {
        try {
            return SW360AttachmentUtils.calculateHash(file, MessageDigest.getInstance(ALG_SHA1));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"SHA-1 algorithm not supported");
        }
    }

    static Path safeCreateDirectory(Path path, boolean withParents) throws IOException {
        while (!Files.exists(path, new LinkOption[0])) {
            try {
                LOGGER.info("Creating attachment download path {}.", (Object)path);
                return withParents ? Files.createDirectories(path, new FileAttribute[0]) : Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                LOGGER.debug("Concurrent creation of directory {}. Ignoring exception.", (Object)path);
            }
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new FileAlreadyExistsException(path.toString());
        }
        return path;
    }

    private static boolean attachmentIsPotentialDuplicate(Path attachment, Set<SW360SparseAttachment> attachments) {
        return attachments.stream().anyMatch(attachment1 -> attachment1.getFilename().equals(attachment.getFileName().toString()));
    }

    private static String toHexString(byte[] bytes) {
        char[] encoded = new char[bytes.length * 2];
        int idx = 0;
        for (byte b : bytes) {
            encoded[idx++] = HEX_DIGITS[b >> 4 & 0xF];
            encoded[idx++] = HEX_DIGITS[b & 0xF];
        }
        return new String(encoded);
    }

    public static class AttachmentDownloadProcessor
    implements SW360AttachmentAwareClient.AttachmentProcessor<Path> {
        private final Path downloadPath;
        private final String fileName;
        private final CopyOption[] copyOptions;

        public AttachmentDownloadProcessor(Path downloadPath, String fileName, CopyOption ... options) {
            this.downloadPath = downloadPath;
            this.fileName = fileName;
            this.copyOptions = options;
        }

        public Path getDownloadPath() {
            return this.downloadPath;
        }

        public String getFileName() {
            return this.fileName;
        }

        public CopyOption[] getCopyOptions() {
            return (CopyOption[])this.copyOptions.clone();
        }

        @Override
        public Path processAttachmentStream(InputStream stream) throws IOException {
            Path target = this.getTargetPath();
            LOGGER.info("Downloading attachment to {}.", (Object)target);
            long size = Files.copy(stream, target, this.copyOptions);
            LOGGER.debug("Downloaded {} bytes to {}", (Object)size, (Object)target);
            return target;
        }

        protected Path getTargetPath() throws IOException {
            return this.getDownloadPath().resolve(this.getFileName());
        }
    }

    public static class AttachmentDownloadProcessorCreateDownloadFolder
    extends AttachmentDownloadProcessor {
        public AttachmentDownloadProcessorCreateDownloadFolder(Path downloadPath, String fileName, CopyOption ... options) {
            super(downloadPath, fileName, options);
        }

        @Override
        protected Path getTargetPath() throws IOException {
            SW360AttachmentUtils.safeCreateDirectory(this.getDownloadPath(), false);
            return super.getTargetPath();
        }
    }

    public static class AttachmentDownloadProcessorCreateDownloadFolderWithParents
    extends AttachmentDownloadProcessor {
        public AttachmentDownloadProcessorCreateDownloadFolderWithParents(Path downloadPath, String fileName, CopyOption ... options) {
            super(downloadPath, fileName, options);
        }

        @Override
        protected Path getTargetPath() throws IOException {
            SW360AttachmentUtils.safeCreateDirectory(this.getDownloadPath(), true);
            return super.getTargetPath();
        }
    }
}

