/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.adapter;

import org.eclipse.sw360.clients.adapter.SW360ComponentClientAdapter;
import org.eclipse.sw360.clients.adapter.SW360ComponentClientAdapterAsync;
import org.eclipse.sw360.clients.adapter.SW360ComponentClientAdapterAsyncImpl;
import org.eclipse.sw360.clients.adapter.SW360Connection;
import org.eclipse.sw360.clients.adapter.SW360LicenseClientAdapter;
import org.eclipse.sw360.clients.adapter.SW360LicenseClientAdapterAsync;
import org.eclipse.sw360.clients.adapter.SW360LicenseClientAdapterAsyncImpl;
import org.eclipse.sw360.clients.adapter.SW360ProjectClientAdapter;
import org.eclipse.sw360.clients.adapter.SW360ProjectClientAdapterAsync;
import org.eclipse.sw360.clients.adapter.SW360ProjectClientAdapterAsyncImpl;
import org.eclipse.sw360.clients.adapter.SW360ReleaseClientAdapter;
import org.eclipse.sw360.clients.adapter.SW360ReleaseClientAdapterAsync;
import org.eclipse.sw360.clients.adapter.SW360ReleaseClientAdapterAsyncImpl;
import org.eclipse.sw360.clients.adapter.SW360VulnerabilityClientAdapter;
import org.eclipse.sw360.clients.adapter.SW360VulnerabilityClientAdapterAsync;
import org.eclipse.sw360.clients.adapter.SW360VulnerabilityClientAdapterAsyncImpl;
import org.eclipse.sw360.clients.adapter.SyncClientAdapterHandler;
import org.eclipse.sw360.clients.auth.AccessTokenProvider;
import org.eclipse.sw360.clients.auth.SW360AuthenticationClient;
import org.eclipse.sw360.clients.config.SW360ClientConfig;
import org.eclipse.sw360.clients.rest.SW360ComponentClient;
import org.eclipse.sw360.clients.rest.SW360LicenseClient;
import org.eclipse.sw360.clients.rest.SW360ProjectClient;
import org.eclipse.sw360.clients.rest.SW360ReleaseClient;
import org.eclipse.sw360.clients.rest.SW360VulnerabilityClient;

public class SW360ConnectionFactory {
    public SW360Connection newConnection(SW360ClientConfig config) {
        SW360AuthenticationClient authClient = new SW360AuthenticationClient(config);
        AccessTokenProvider tokenProvider = new AccessTokenProvider(authClient);
        SW360ComponentClient componentClient = new SW360ComponentClient(config, tokenProvider);
        final SW360ComponentClientAdapterAsyncImpl componentAdapterAsync = new SW360ComponentClientAdapterAsyncImpl(componentClient);
        final SW360ComponentClientAdapter componentAdapterSync = SyncClientAdapterHandler.newHandler(SW360ComponentClientAdapter.class, SW360ComponentClientAdapterAsync.class, componentAdapterAsync);
        SW360ReleaseClient releaseClient = new SW360ReleaseClient(config, tokenProvider);
        final SW360ReleaseClientAdapterAsyncImpl releaseAdapterAsync = new SW360ReleaseClientAdapterAsyncImpl(releaseClient, componentAdapterAsync);
        final SW360ReleaseClientAdapter releaseAdapterSync = SyncClientAdapterHandler.newHandler(SW360ReleaseClientAdapter.class, SW360ReleaseClientAdapterAsync.class, releaseAdapterAsync);
        SW360LicenseClient licenseClient = new SW360LicenseClient(config, tokenProvider);
        final SW360LicenseClientAdapterAsyncImpl licenseAdapterAsync = new SW360LicenseClientAdapterAsyncImpl(licenseClient);
        final SW360LicenseClientAdapter licenseAdapterSync = SyncClientAdapterHandler.newHandler(SW360LicenseClientAdapter.class, SW360LicenseClientAdapterAsync.class, licenseAdapterAsync);
        SW360ProjectClient projectClient = new SW360ProjectClient(config, tokenProvider);
        final SW360ProjectClientAdapterAsyncImpl projectAdapterAsync = new SW360ProjectClientAdapterAsyncImpl(projectClient);
        final SW360ProjectClientAdapter projectAdapterSync = SyncClientAdapterHandler.newHandler(SW360ProjectClientAdapter.class, SW360ProjectClientAdapterAsync.class, projectAdapterAsync);
        SW360VulnerabilityClient vulnerabilityClient = new SW360VulnerabilityClient(config, tokenProvider);
        final SW360VulnerabilityClientAdapterAsyncImpl vulnerabilityAdapterAsync = new SW360VulnerabilityClientAdapterAsyncImpl(vulnerabilityClient);
        final SW360VulnerabilityClientAdapter vulnerabilityAdapterSync = SyncClientAdapterHandler.newHandler(SW360VulnerabilityClientAdapter.class, SW360VulnerabilityClientAdapterAsync.class, vulnerabilityAdapterAsync);
        return new SW360Connection(){

            @Override
            public SW360ComponentClientAdapter getComponentAdapter() {
                return componentAdapterSync;
            }

            @Override
            public SW360ComponentClientAdapterAsync getComponentAdapterAsync() {
                return componentAdapterAsync;
            }

            @Override
            public SW360ReleaseClientAdapter getReleaseAdapter() {
                return releaseAdapterSync;
            }

            @Override
            public SW360ReleaseClientAdapterAsync getReleaseAdapterAsync() {
                return releaseAdapterAsync;
            }

            @Override
            public SW360LicenseClientAdapter getLicenseAdapter() {
                return licenseAdapterSync;
            }

            @Override
            public SW360LicenseClientAdapterAsync getLicenseAdapterAsync() {
                return licenseAdapterAsync;
            }

            @Override
            public SW360ProjectClientAdapter getProjectAdapter() {
                return projectAdapterSync;
            }

            @Override
            public SW360ProjectClientAdapterAsync getProjectAdapterAsync() {
                return projectAdapterAsync;
            }

            @Override
            public SW360VulnerabilityClientAdapter getVulnerabilityAdapter() {
                return vulnerabilityAdapterSync;
            }

            @Override
            public SW360VulnerabilityClientAdapterAsync getVulnerabilityAdapterAsync() {
                return vulnerabilityAdapterAsync;
            }
        };
    }
}

