/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.adapter;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.clients.rest.MultiStatusResponse;
import org.eclipse.sw360.clients.utils.SW360ClientException;
import org.eclipse.sw360.http.utils.FailedRequestException;
import org.eclipse.sw360.http.utils.HttpUtils;

class SW360DeleteUtils {
    private SW360DeleteUtils() {
    }

    public static CompletableFuture<MultiStatusResponse> deleteEntities(EntityDeleter deleter, Collection<String> idsToDelete) {
        return idsToDelete.isEmpty() ? CompletableFuture.completedFuture(new MultiStatusResponse(Collections.emptyMap())) : deleter.deleteEntities(idsToDelete);
    }

    public static CompletableFuture<Void> deleteEntity(EntityDeleter deleter, String resourceId, String resourceType) {
        return deleter.deleteEntities(Collections.singleton(resourceId)).thenApply(status -> {
            SW360DeleteUtils.checkResponse(status, resourceId, resourceType);
            return null;
        });
    }

    private static void checkResponse(MultiStatusResponse status, String resourceId, String resourceType) {
        if (status.responseCount() != 1 || !status.hasResourceId(resourceId)) {
            throw new SW360ClientException("Unexpected multi-status response. Expected a response that contains only a status for " + resourceId + ", but got: " + String.valueOf(status));
        }
        if (!HttpUtils.isSuccessStatus((int)status.getStatus(resourceId))) {
            FailedRequestException requestException = new FailedRequestException(SW360DeleteUtils.generateDeleteTag(resourceId, resourceType), status.getStatus(resourceId));
            throw new SW360ClientException("Delete operation failed", (Throwable)requestException);
        }
    }

    private static String generateDeleteTag(String resourceId, String resourceType) {
        return "delete " + resourceType + " " + resourceId;
    }

    @FunctionalInterface
    static interface EntityDeleter {
        public CompletableFuture<MultiStatusResponse> deleteEntities(Collection<String> var1);
    }
}

