/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.adapter;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.sw360.clients.adapter.SW360ProjectAdapterUtils;
import org.eclipse.sw360.clients.adapter.SW360ProjectClientAdapterAsync;
import org.eclipse.sw360.clients.rest.SW360ProjectClient;
import org.eclipse.sw360.clients.rest.resource.LinkObjects;
import org.eclipse.sw360.clients.rest.resource.SW360HalResource;
import org.eclipse.sw360.clients.rest.resource.Self;
import org.eclipse.sw360.clients.rest.resource.projects.ProjectSearchParams;
import org.eclipse.sw360.clients.rest.resource.projects.SW360Project;
import org.eclipse.sw360.clients.rest.resource.releases.SW360Release;
import org.eclipse.sw360.clients.rest.resource.releases.SW360SparseRelease;
import org.eclipse.sw360.clients.utils.FutureUtils;
import org.eclipse.sw360.clients.utils.SW360ClientException;

class SW360ProjectClientAdapterAsyncImpl
implements SW360ProjectClientAdapterAsync {
    private final SW360ProjectClient projectClient;

    public SW360ProjectClientAdapterAsyncImpl(SW360ProjectClient client) {
        this.projectClient = client;
    }

    @Override
    public SW360ProjectClient getProjectClient() {
        return this.projectClient;
    }

    @Override
    public CompletableFuture<Optional<SW360Project>> getProjectByNameAndVersion(String projectName, String projectVersion) {
        ProjectSearchParams nameSearchParams = ProjectSearchParams.builder().withName(projectName).build();
        return this.getProjectClient().search(nameSearchParams).thenApply(projects -> projects.stream().filter(pr -> SW360ProjectAdapterUtils.hasEqualCoordinates(pr, projectName, projectVersion)).findAny());
    }

    @Override
    public CompletableFuture<List<SW360Project>> search(ProjectSearchParams params) {
        return this.getProjectClient().search(params);
    }

    @Override
    public CompletableFuture<SW360Project> createProject(SW360Project project) {
        return SW360ProjectClientAdapterAsyncImpl.validateProjectAndProcess(project, this.getProjectClient()::createProject);
    }

    @Override
    public CompletableFuture<SW360Project> updateProject(SW360Project project) {
        return SW360ProjectClientAdapterAsyncImpl.validateProjectAndProcess(project, this.getProjectClient()::updateProject);
    }

    @Override
    public CompletableFuture<Void> addSW360ReleasesToSW360Project(String id, Collection<SW360Release> releases) {
        List<String> releaseLinks = releases.stream().map(SW360HalResource::getLinks).filter(Objects::nonNull).map(LinkObjects::getSelf).filter(Objects::nonNull).map(Self::getHref).collect(Collectors.toList());
        return this.getProjectClient().addReleasesToProject(id, releaseLinks);
    }

    @Override
    public CompletableFuture<List<SW360SparseRelease>> getLinkedReleases(String projectId, boolean transitive) {
        return this.getProjectClient().getLinkedReleases(projectId, transitive);
    }

    @Override
    public CompletableFuture<Integer> deleteProject(String projectId) {
        return this.getProjectClient().deleteProject(projectId);
    }

    private static CompletableFuture<SW360Project> validateProjectAndProcess(SW360Project project, Function<SW360Project, CompletableFuture<SW360Project>> func) {
        if (!SW360ProjectAdapterUtils.isValidProject(project)) {
            SW360ClientException exception = new SW360ClientException("Can not create invalid project with name=" + project.getName() + " and version=" + project.getVersion());
            return FutureUtils.failedFuture(exception);
        }
        return func.apply(project);
    }
}

