/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.adapter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.clients.utils.FutureUtils;

final class SyncClientAdapterHandler
implements InvocationHandler {
    private static final String METHOD_EQUALS = "equals";
    private final Class<?> asyncIfcClass;
    private final Object delegate;

    private SyncClientAdapterHandler(Class<?> asyncIfcClass, Object delegate) {
        this.asyncIfcClass = asyncIfcClass;
        this.delegate = delegate;
    }

    public static <S, A> S newHandler(Class<? extends S> syncIfcClass, Class<? super A> asyncIfcClass, A delegateAdapter) {
        SyncClientAdapterHandler handler = new SyncClientAdapterHandler(asyncIfcClass, delegateAdapter);
        Class[] ifcClasses = new Class[]{syncIfcClass};
        return syncIfcClass.cast(Proxy.newProxyInstance(syncIfcClass.getClassLoader(), ifcClasses, (InvocationHandler)handler));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class)) {
            return this.handleMethodFromObject(method, args);
        }
        Method asyncMethod = this.asyncIfcClass.getMethod(method.getName(), method.getParameterTypes());
        Object result = asyncMethod.invoke(this.delegate, args);
        if (result instanceof CompletableFuture) {
            CompletableFuture futResult = (CompletableFuture)result;
            return FutureUtils.block(futResult);
        }
        return result;
    }

    private Object handleMethodFromObject(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        if (METHOD_EQUALS.equals(method.getName())) {
            Object other = args[0];
            if (!Proxy.isProxyClass(other.getClass())) {
                return false;
            }
            InvocationHandler otherHandler = Proxy.getInvocationHandler(other);
            return otherHandler instanceof SyncClientAdapterHandler && ((SyncClientAdapterHandler)otherHandler).delegate == this.delegate;
        }
        return method.invoke(this.delegate, args);
    }
}

