/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class CommonUtils {
    public static final String SYSTEM_CONFIGURATION_PATH = "/etc/sw360";

    public static Properties loadProperties(Class<?> clazz, String propertiesFilePath) {
        return CommonUtils.loadProperties(clazz, propertiesFilePath, true);
    }

    public static Properties loadProperties(Class<?> clazz, String propertiesFilePath, boolean useSystemConfig) {
        File systemPropertiesFile;
        Properties props = new Properties();
        try (InputStream resourceAsStream2 = clazz.getResourceAsStream(propertiesFilePath);){
            if (resourceAsStream2 == null) {
                throw new IOException("cannot open " + propertiesFilePath);
            }
            props.load(resourceAsStream2);
        }
        catch (IOException resourceAsStream2) {
            // empty catch block
        }
        if (useSystemConfig && (systemPropertiesFile = new File(SYSTEM_CONFIGURATION_PATH, propertiesFilePath)).exists()) {
            try (FileInputStream resourceAsStream = new FileInputStream(systemPropertiesFile.getPath());){
                if (resourceAsStream == null) {
                    throw new IOException("cannot open " + systemPropertiesFile.getPath());
                }
                props.load(resourceAsStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return props;
    }

    public static Optional<byte[]> loadResource(Class<?> clazz, String resourceFilePath) {
        return CommonUtils.loadResource(clazz, resourceFilePath, true);
    }

    public static Optional<byte[]> loadResource(Class<?> clazz, String resourceFilePath, boolean useSystemResourses) {
        Optional<byte[]> optional;
        block19: {
            File systemResourceFile;
            if (resourceFilePath == null || resourceFilePath.isBlank()) {
                return Optional.empty();
            }
            if (useSystemResourses && (systemResourceFile = new File(SYSTEM_CONFIGURATION_PATH, resourceFilePath)).exists()) {
                Optional<byte[]> optional2;
                FileInputStream resourceAsStream = new FileInputStream(systemResourceFile.getPath());
                try {
                    if (resourceAsStream == null) {
                        throw new IOException("cannot open " + systemResourceFile.getPath());
                    }
                    optional2 = Optional.of(IOUtils.toByteArray((InputStream)resourceAsStream));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)resourceAsStream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ((InputStream)resourceAsStream).close();
                return optional2;
            }
            InputStream resourceAsStream = clazz.getResourceAsStream(resourceFilePath);
            try {
                if (resourceAsStream == null) {
                    throw new IOException("cannot open " + resourceFilePath);
                }
                optional = Optional.of(IOUtils.toByteArray((InputStream)resourceAsStream));
                if (resourceAsStream == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return Optional.empty();
                }
            }
            resourceAsStream.close();
        }
        return optional;
    }
}

