/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.rest;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.clients.auth.AccessTokenProvider;
import org.eclipse.sw360.clients.config.SW360ClientConfig;
import org.eclipse.sw360.clients.rest.MultiStatusResponse;
import org.eclipse.sw360.clients.rest.PagingResult;
import org.eclipse.sw360.clients.rest.SW360Client;
import org.eclipse.sw360.clients.rest.resource.PagingLinkObjects;
import org.eclipse.sw360.clients.rest.resource.components.ComponentSearchParams;
import org.eclipse.sw360.clients.rest.resource.components.SW360Component;
import org.eclipse.sw360.clients.rest.resource.components.SW360ComponentList;
import org.eclipse.sw360.clients.rest.resource.components.SW360SparseComponent;
import org.eclipse.sw360.clients.utils.SW360ResourceUtils;
import org.eclipse.sw360.http.RequestBuilder;
import org.eclipse.sw360.http.utils.HttpUtils;

public class SW360ComponentClient
extends SW360Client {
    static final String TAG_GET_COMPONENTS = "get_components";
    static final String TAG_GET_COMPONENT = "get_component";
    static final String TAG_CREATE_COMPONENT = "post_create_component";
    static final String TAG_UPDATE_COMPONENT = "patch_update_component";
    static final String TAG_DELETE_COMPONENTS = "delete_components";
    private static final String COMPONENTS_ENDPOINT = "components";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_PAGE = "page";
    private static final String PARAM_PAGE_SIZE = "page_entries";
    private static final String PARAM_SORT = "sort";
    private static final String PARAM_FIELDS = "fields";

    public SW360ComponentClient(SW360ClientConfig config, AccessTokenProvider provider) {
        super(config, provider);
    }

    public CompletableFuture<SW360Component> getComponent(String componentId) {
        return this.executeJsonRequest(HttpUtils.get((String)this.resourceUrl(COMPONENTS_ENDPOINT, componentId)), SW360Component.class, TAG_GET_COMPONENT);
    }

    public CompletableFuture<PagingResult<SW360SparseComponent>> search(ComponentSearchParams searchParams) {
        Map<String, Object> params = SW360ComponentClient.createSearchQueryParameters(searchParams);
        String url = HttpUtils.addQueryParameters((String)this.resourceUrl(COMPONENTS_ENDPOINT), params, (boolean)true);
        return this.executeJsonRequestWithDefault(HttpUtils.get((String)url), SW360ComponentList.class, TAG_GET_COMPONENTS, SW360ComponentList::new).thenApply(SW360ComponentClient::createPagingComponentResult);
    }

    public CompletableFuture<SW360Component> createComponent(SW360Component sw360Component) {
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.POST).uri(this.resourceUrl(COMPONENTS_ENDPOINT)).body(body -> body.json((Object)sw360Component)), SW360Component.class, TAG_CREATE_COMPONENT);
    }

    public CompletableFuture<SW360Component> patchComponent(SW360Component component) {
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.PATCH).uri(this.resourceUrl(COMPONENTS_ENDPOINT, component.getId())).body(body -> body.json((Object)component)), SW360Component.class, TAG_UPDATE_COMPONENT);
    }

    public CompletableFuture<MultiStatusResponse> deleteComponents(Collection<String> idsToDelete) {
        return this.executeDeleteRequest(COMPONENTS_ENDPOINT, idsToDelete, TAG_DELETE_COMPONENTS);
    }

    private static Map<String, Object> createSearchQueryParameters(ComponentSearchParams searchParams) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_NAME, searchParams.getName());
        params.put(PARAM_TYPE, searchParams.getComponentType());
        params.put(PARAM_PAGE, searchParams.getPageIndex());
        params.put(PARAM_PAGE_SIZE, searchParams.getPageSize());
        params.put(PARAM_SORT, SW360ComponentClient.multiParam(searchParams.getOrderClauses()));
        params.put(PARAM_FIELDS, SW360ComponentClient.multiParam(searchParams.getFields()));
        return params;
    }

    private static String multiParam(List<String> values) {
        return String.join((CharSequence)",", values);
    }

    private static PagingResult<SW360SparseComponent> createPagingComponentResult(SW360ComponentList componentList) {
        List<SW360SparseComponent> components = SW360ResourceUtils.getSw360SparseComponents(componentList);
        return new PagingResult<SW360SparseComponent>(components, componentList.getPage(), (PagingLinkObjects)componentList.getLinks());
    }
}

