/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.rest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.eclipse.sw360.clients.auth.AccessTokenProvider;
import org.eclipse.sw360.clients.config.SW360ClientConfig;
import org.eclipse.sw360.clients.rest.SW360Client;
import org.eclipse.sw360.clients.rest.resource.projects.ProjectSearchParams;
import org.eclipse.sw360.clients.rest.resource.projects.SW360Project;
import org.eclipse.sw360.clients.rest.resource.projects.SW360ProjectList;
import org.eclipse.sw360.clients.rest.resource.releases.SW360ReleaseList;
import org.eclipse.sw360.clients.rest.resource.releases.SW360SparseRelease;
import org.eclipse.sw360.clients.utils.SW360ResourceUtils;
import org.eclipse.sw360.http.RequestBuilder;
import org.eclipse.sw360.http.utils.HttpUtils;

public class SW360ProjectClient
extends SW360Client {
    static final String TAG_SEARCH_PROJECTS = "get_search_projects";
    static final String TAG_CREATE_PROJECT = "post_create_project";
    static final String TAG_UPDATE_PROJECT = "patch_update_project";
    static final String TAG_DELETE_PROJECT = "delete_project";
    static final String TAG_ADD_RELEASES_TO_PROJECT = "post_add_releases_to_project";
    static final String TAG_GET_LINKED_RELEASES = "get_releases_linked_to_project";
    private static final String PROJECTS_ENDPOINT = "projects";

    public SW360ProjectClient(SW360ClientConfig config, AccessTokenProvider provider) {
        super(config, provider);
    }

    public CompletableFuture<List<SW360Project>> search(ProjectSearchParams searchParams) {
        String queryUrl = HttpUtils.addQueryParameters((String)this.resourceUrl(PROJECTS_ENDPOINT), SW360ProjectClient.parametersMap(searchParams), (boolean)true);
        return this.executeJsonRequestWithDefault(HttpUtils.get((String)queryUrl), SW360ProjectList.class, TAG_SEARCH_PROJECTS, SW360ProjectList::new).thenApply(SW360ResourceUtils::getSw360Projects);
    }

    public CompletableFuture<SW360Project> createProject(SW360Project sw360Project) {
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.POST).uri(this.resourceUrl(PROJECTS_ENDPOINT)).body(body -> body.json((Object)sw360Project)), SW360Project.class, TAG_CREATE_PROJECT);
    }

    public CompletableFuture<SW360Project> updateProject(SW360Project project) {
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.PATCH).uri(this.resourceUrl(PROJECTS_ENDPOINT, project.getId())).body(body -> body.json((Object)project)), SW360Project.class, TAG_UPDATE_PROJECT);
    }

    public CompletableFuture<Void> addReleasesToProject(String projectId, List<String> releases) {
        return this.executeRequest(builder -> builder.method(RequestBuilder.Method.POST).uri(this.resourceUrl(PROJECTS_ENDPOINT, projectId, "releases")).body(body -> body.json((Object)releases)), HttpUtils.nullProcessor(), TAG_ADD_RELEASES_TO_PROJECT);
    }

    public CompletableFuture<Integer> deleteProject(String projectId) {
        String url = this.resourceUrl(PROJECTS_ENDPOINT, projectId);
        return this.executeRequest(builder -> builder.uri(url).method(RequestBuilder.Method.DELETE), HttpUtils.checkResponse(response -> response.statusCode(), (Predicate)HttpUtils.hasStatus((int)200), (String)TAG_DELETE_PROJECT), TAG_DELETE_PROJECT);
    }

    public CompletableFuture<List<SW360SparseRelease>> getLinkedReleases(String projectId, boolean transitive) {
        String uri = HttpUtils.addQueryParameter((String)this.resourceUrl(PROJECTS_ENDPOINT, projectId, "releases"), (String)"transitive", (Object)transitive);
        return this.executeJsonRequestWithDefault(HttpUtils.get((String)uri), SW360ReleaseList.class, TAG_GET_LINKED_RELEASES, SW360ReleaseList::new).thenApply(SW360ResourceUtils::getSw360SparseReleases);
    }

    private static Map<String, String> parametersMap(ProjectSearchParams params) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", params.getName());
        paramMap.put("group", params.getBusinessUnit());
        paramMap.put("tag", params.getTag());
        if (params.getType() != null) {
            paramMap.put("type", params.getType().name());
        }
        return paramMap;
    }
}

