/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.rest;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.eclipse.sw360.clients.auth.AccessTokenProvider;
import org.eclipse.sw360.clients.config.SW360ClientConfig;
import org.eclipse.sw360.clients.rest.SW360Client;
import org.eclipse.sw360.clients.rest.resource.vulnerabilities.SW360ReleaseVulnerabilityRelation;
import org.eclipse.sw360.clients.rest.resource.vulnerabilities.SW360Vulnerability;
import org.eclipse.sw360.clients.rest.resource.vulnerabilities.SW360VulnerabilityList;
import org.eclipse.sw360.clients.utils.SW360ResourceUtils;
import org.eclipse.sw360.http.RequestBuilder;
import org.eclipse.sw360.http.utils.HttpUtils;

public class SW360VulnerabilityClient
extends SW360Client {
    static final String TAG_GET_VULNERABILITIES = "get_vulnerabilities";
    static final String TAG_GET_VULNERABILITY_BY_EXTERNAL_IDS = "get_vulnerability_by_external_id";
    static final String TAG_CREATE_VULNERABILITY = "post_create_vulnerability";
    static final String TAG_UPDATE_VULNERABILITY = "patch_update_vulnerability";
    static final String TAG_DELETE_VULNERABILITY = "delete_vulnerability";
    static final String TAG_CREATE_VULNERABILITY_RELEASE_RELATION = "post_create_vulnerability_release_relation";
    static final String TAG_DELETE_VULNERABILITY_RELEASE_RELATION = "delete_vulnerability_release_relation";
    private static final String VULNERABILITIES_ENDPOINT_APPENDIX = "vulnerabilities";
    private static final String PATH_RELEASE_VULNERABILITY_RELATION_CREATE = "releaseVulnerabilityRelation";
    private static final String PATH_RELEASE_VULNERABILITY_RELATION_DELETE = "release";

    public SW360VulnerabilityClient(SW360ClientConfig config, AccessTokenProvider provider) {
        super(config, provider);
    }

    public CompletableFuture<List<SW360Vulnerability>> getVulnerabilities() {
        return this.executeJsonRequestWithDefault(HttpUtils.get((String)this.resourceUrl(VULNERABILITIES_ENDPOINT_APPENDIX)), SW360VulnerabilityList.class, VULNERABILITIES_ENDPOINT_APPENDIX, SW360VulnerabilityList::new).thenApply(SW360ResourceUtils::getSw360Vulnerabilities);
    }

    public CompletableFuture<SW360Vulnerability> getVulnerabilityByExternalId(String externalId) {
        return this.executeJsonRequest(HttpUtils.get((String)this.resourceUrl(VULNERABILITIES_ENDPOINT_APPENDIX, externalId)), SW360Vulnerability.class, TAG_GET_VULNERABILITY_BY_EXTERNAL_IDS);
    }

    public CompletableFuture<SW360Vulnerability> createVulnerability(SW360Vulnerability sw360Vulnerability) {
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.POST).uri(this.resourceUrl(VULNERABILITIES_ENDPOINT_APPENDIX)).body(body -> body.json((Object)sw360Vulnerability)), SW360Vulnerability.class, TAG_CREATE_VULNERABILITY);
    }

    public CompletableFuture<SW360Vulnerability> patchVulnerability(SW360Vulnerability sw360Vulnerability, String externalId) {
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.PATCH).uri(this.resourceUrl(VULNERABILITIES_ENDPOINT_APPENDIX, externalId)).body(body -> body.json((Object)sw360Vulnerability)), SW360Vulnerability.class, TAG_UPDATE_VULNERABILITY);
    }

    public CompletableFuture<Integer> deleteVulnerability(String externalId) {
        String url = this.resourceUrl(VULNERABILITIES_ENDPOINT_APPENDIX, externalId);
        return this.executeRequest(builder -> builder.uri(url).method(RequestBuilder.Method.DELETE), HttpUtils.checkResponse(response -> response.statusCode(), (Predicate)HttpUtils.hasStatus((int)200), (String)TAG_DELETE_VULNERABILITY_RELEASE_RELATION), TAG_DELETE_VULNERABILITY);
    }

    public CompletableFuture<SW360ReleaseVulnerabilityRelation> createVulnerabilityReleaseRelation(String externalId, SW360ReleaseVulnerabilityRelation sw360ReleaseVulnerabilityRelation) {
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.POST).uri(this.resourceUrl(VULNERABILITIES_ENDPOINT_APPENDIX, externalId, PATH_RELEASE_VULNERABILITY_RELATION_CREATE)).body(body -> body.json((Object)sw360ReleaseVulnerabilityRelation)), SW360ReleaseVulnerabilityRelation.class, TAG_CREATE_VULNERABILITY_RELEASE_RELATION);
    }

    public CompletableFuture<Integer> deleteVulnerabilityReleaseRelation(String externalId, String releaseId) {
        String url = this.resourceUrl(VULNERABILITIES_ENDPOINT_APPENDIX, externalId, PATH_RELEASE_VULNERABILITY_RELATION_DELETE, releaseId);
        return this.executeRequest(builder -> builder.uri(url).method(RequestBuilder.Method.DELETE), HttpUtils.checkResponse(response -> response.statusCode(), (Predicate)HttpUtils.hasStatus((int)200), (String)TAG_DELETE_VULNERABILITY_RELEASE_RELATION), TAG_DELETE_VULNERABILITY_RELEASE_RELATION);
    }
}

