/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.rest.resource;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.eclipse.sw360.clients.rest.resource.Embedded;
import org.eclipse.sw360.clients.rest.resource.LinkObjects;
import org.eclipse.sw360.clients.rest.resource.SW360HalResourceUtility;
import org.eclipse.sw360.clients.rest.resource.Self;

public abstract class SW360HalResource<L extends LinkObjects, E extends Embedded> {
    private L links = this.createEmptyLinks();
    private E embedded = this.createEmptyEmbedded();

    public abstract L createEmptyLinks();

    public abstract E createEmptyEmbedded();

    @JsonIgnore
    public Self getSelfLink() {
        return ((LinkObjects)this.links).getSelf();
    }

    @JsonIgnore
    public String getId() {
        return SW360HalResourceUtility.getLastIndexOfSelfLink(this.getLinks()).orElse(null);
    }

    @JsonGetter(value="_links")
    public L getLinks() {
        return this.links;
    }

    @JsonSetter(value="_links")
    public SW360HalResource<L, E> setLinks(L links) {
        if (links != null) {
            this.links = links;
        }
        return this;
    }

    @JsonGetter(value="_embedded")
    public E getEmbedded() {
        return this.embedded;
    }

    @JsonSetter(value="_embedded")
    public SW360HalResource<L, E> setEmbedded(E embedded) {
        if (embedded != null) {
            this.embedded = embedded;
        }
        return this;
    }

    public String toString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return super.toString();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SW360HalResource)) {
            return false;
        }
        SW360HalResource that = (SW360HalResource)o;
        return that.canEqual(this) && Objects.equals(this.links, that.links) && Objects.equals(this.embedded, that.embedded);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.embedded);
    }

    public boolean canEqual(Object o) {
        return o instanceof SW360HalResource;
    }

    public static enum EmptyEmbedded implements Embedded
    {
        INSTANCE;

    }
}

